<?php
// File name: jwt.php
// File location: /home/apimedi1/public_html/api/v1/utils/jwt.php

// ONLY DEFINE IF NOT ALREADY DEFINED
if (!defined('JWT_SECRET')) {
    define('JWT_SECRET', 'x7k9m3p2q8r5t1v4w6u9y0z2a3b5c7d8e9f1g2h3j4k5l6m7n8o9p0q1r2s3t4u5v6w7x8y9z0');
    // CHANGE THIS IN PRODUCTION — 256-bit minimum
}

function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function generateJWT($userId, $regionCode) {
    $header = base64url_encode(json_encode(['alg' => 'HS256', 'typ' => 'JWT']));
    $payload = base64url_encode(json_encode([
        'userId' => $userId,
        'regionCode' => $regionCode,
        'exp' => time() + 3600
    ]));
    $signature = base64url_encode(hash_hmac('sha256', "$header.$payload", JWT_SECRET, true));
    return "$header.$payload.$signature";
}

function validateJWT($token) {
    $parts = explode('.', $token);
    if (count($parts) !== 3) return false;
    list($headerB64, $payloadB64, $signatureB64) = $parts;
    $expected = base64url_encode(hash_hmac('sha256', "$headerB64.$payloadB64", JWT_SECRET, true));
    if (!hash_equals($expected, $signatureB64)) return false;

    // Check if token is revoked
    $connMain = getConnMain();
    $revokeCheck = $connMain->prepare("
        SELECT 1 FROM revoked_tokens WHERE token = ? AND revoked_at < NOW() + INTERVAL (expiry - UNIX_TIMESTAMP()) SECOND
    ");
    if (!$revokeCheck) {
        return false; // Fail safe if prepare fails
    }
    $revokeCheck->bind_param("s", $token);
    $revokeCheck->execute();
    $revokeResult = $revokeCheck->get_result();
    if ($revokeResult->num_rows > 0) {
        $revokeCheck->close();
        return false; // Token revoked
    }
    $revokeCheck->close();

    $payload = json_decode(base64_decode($payloadB64), true);
    return ($payload && ($payload['exp'] ?? 0) > time()) ? $payload : false;
}
?>