<?php
// File name: transactions.php
// File location: /home/apimedi1/public_html/api/v1/routes/rewards/transactions.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userPayload = validateJWT($_SERVER['HTTP_AUTHORIZATION'] ?? '');
if (!$userPayload) {
    (new Response)->json(['error' => 'Invalid token'], 401);
}
$userId = $userPayload['userId'];

$connRewards = getConnRewards();

$stmtAccount = $connRewards->prepare("SELECT id FROM rewards_accounts WHERE user_id = ? AND role_type = 'Patient'");
$stmtAccount->bind_param("i", $userId);
$stmtAccount->execute();
$resultAccount = $stmtAccount->get_result();
$accountRow = $resultAccount->fetch_assoc();
$accountId = $accountRow['id'];

$page = max(1, (int)($_GET['page'] ?? 1));
$limit = min(50, (int)($_GET['limit'] ?? 10));
$offset = ($page - 1) * $limit;

$stmtTotal = $connRewards->prepare("SELECT COUNT(*) AS total FROM transactions WHERE account_id = ?");
$stmtTotal->bind_param("i", $accountId);
$stmtTotal->execute();
$totalResult = $stmtTotal->get_result();
$totalRow = $totalResult->fetch_assoc();
$total = $totalRow['total'];

$stmt = $connRewards->prepare("SELECT * FROM transactions WHERE account_id = ? ORDER BY transaction_date DESC LIMIT ? OFFSET ?");
$stmt->bind_param("iii", $accountId, $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();
$transactions = [];
while ($row = $result->fetch_assoc()) {
    $transactions[] = $row;
}

(new Response)->json(['transactions' => $transactions, 'total' => $total, 'page' => $page, 'limit' => $limit]);
?>