<?php
// File name: rewards.php
// File location: /home/apimedi1/public_html/api/v1/routes/rewards/rewards.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';

$userPayload = validateJWT($_SERVER['HTTP_AUTHORIZATION'] ?? '');
if (!$userPayload) {
    (new Response)->json(['error' => 'Invalid token'], 401);
}
$userId = $userPayload['userId'];
$region = $userPayload['regionCode'] ?? 'GLOBAL';

$connRewards = getConnRewards();

$stmtAccount = $connRewards->prepare("SELECT id FROM rewards_accounts WHERE user_id = ? AND role_type = 'Patient'");
$stmtAccount->bind_param("i", $userId);
$stmtAccount->execute();
$resultAccount = $stmtAccount->get_result();
if ($resultAccount->num_rows === 0) {
    (new Response)->json(['error' => 'No rewards account found'], 404);
}
$accountRow = $resultAccount->fetch_assoc();
$accountId = $accountRow['id'];

$stmtBalance = $connRewards->prepare("SELECT SUM(CASE WHEN transaction_type = 'Earned' THEN points ELSE -points END) AS balance FROM transactions WHERE account_id = ?");
$stmtBalance->bind_param("i", $accountId);
$stmtBalance->execute();
$resultBalance = $stmtBalance->get_result();
$balanceRow = $resultBalance->fetch_assoc();
$balance = (int)($balanceRow['balance'] ?? 0);

$stmtLevel = $connRewards->prepare("SELECT level_name FROM reward_levels WHERE points_required <= ? AND region = ? ORDER BY points_required DESC LIMIT 1");
$stmtLevel->bind_param("is", $balance, $region);
$stmtLevel->execute();
$resultLevel = $stmtLevel->get_result();
$levelRow = $resultLevel->fetch_assoc();
$level = $levelRow['level_name'] ?? 'Bronze';

(new Response)->json(['balance' => $balance, 'level' => $level]);
?>