<?php
// File name: inventory.php
// File location: /home/apimedi1/public_html/api/v1/routes/rewards/inventory.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userPayload = validateJWT($_SERVER['HTTP_AUTHORIZATION'] ?? '');
if (!$userPayload) {
    (new Response)->json(['error' => 'Invalid token'], 401);
}

$itemId = (int)($_GET['item_id'] ?? 0);
if ($itemId === 0) {
    (new Response)->json(['error' => 'Invalid item ID'], 400);
}

$connRewards = getConnRewards();

$stmt = $connRewards->prepare("SELECT available_units FROM product_inventory WHERE reward_type_id = ?");
$stmt->bind_param("i", $itemId);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    (new Response)->json(['available' => null]); // Unlimited or not found
}
$row = $result->fetch_assoc();
(new Response)->json(['available' => $row['available_units']]);
?>