<?php
// File name: challenges.php
// File location: /home/apimedi1/public_html/api/v1/routes/rewards/challenges.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';

$userPayload = validateJWT($_SERVER['HTTP_AUTHORIZATION'] ?? '');
if (!$userPayload) {
    (new Response)->json(['error' => 'Invalid token'], 401);
}
$userId = $userPayload['userId'];
$region = $userPayload['regionCode'] ?? 'GLOBAL';

$connMain = getDatabaseConnection('main', $region);
$stmtPatient = $connMain->prepare("SELECT id FROM patients WHERE user_id = ?");
$stmtPatient->bind_param("i", $userId);
$stmtPatient->execute();
$resultPatient = $stmtPatient->get_result();
if ($resultPatient->num_rows === 0) {
    (new Response)->json(['error' => 'Patient not found'], 404);
}
$patientRow = $resultPatient->fetch_assoc();
$patientId = $patientRow['id'];

$connRewards = getConnRewards();
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    if (isset($_GET['challenge_id'])) {
        $challengeId = (int)$_GET['challenge_id'];
        $stmt = $connRewards->prepare("SELECT * FROM role_challenges WHERE id = ? AND role_id = ? AND role_type = 'Patient' AND region = ?");
        $stmt->bind_param("iis", $challengeId, $patientId, $region);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            (new Response)->json(['error' => 'Challenge not found'], 404);
        }
        $challenge = $result->fetch_assoc();
        (new Response)->json($challenge);
    } else {
        $stmt = $connRewards->prepare("SELECT * FROM role_challenges WHERE role_id = ? AND role_type = 'Patient' AND region = ?");
        $stmt->bind_param("is", $patientId, $region);
        $stmt->execute();
        $result = $stmt->get_result();
        $challenges = [];
        while ($row = $result->fetch_assoc()) {
            $challenges[] = $row;
        }
        (new Response)->json($challenges);
    }
} elseif ($method === 'POST' && isset($_GET['challenge_id'])) {
    $input = getJsonInput();
    $progress = (int)($input['progress'] ?? 0);
    $challengeId = (int)$_GET['challenge_id'];

    $stmtUpdate = $connRewards->prepare("UPDATE role_challenges SET status = 'in_progress' WHERE id = ? AND role_id = ?"); // Simplified, add real progress logic
    $stmtUpdate->bind_param("ii", $challengeId, $patientId);
    $stmtUpdate->execute();

    (new Response)->json(['updated' => true]);
} else {
    (new Response)->json(['error' => 'Method not allowed'], 405);
}
?>