<?php
// File name: locations.php
// File location: /home/apimedi1/public_html/api/v1/routes/panic/locations.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../../../../secure/config_v2.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

$response = new Response();
$input = getJsonInput();
$method = $_SERVER['REQUEST_METHOD'];

$conn_panic = getDatabaseConnection('panic_service', 'GBL');
if (!$conn_panic) {
    $response->json(['error' => 'Database connection failed'], 500);
}

$type = $_GET['type'] ?? ''; // 'provider' or 'vehicle'

if (!in_array($type, ['provider', 'vehicle'])) {
    $response->json(['error' => 'Invalid type (must be provider or vehicle)'], 400);
}

$table = $type === 'provider' ? 'provider_locations' : 'vehicle_locations';
$id_key = $type === 'provider' ? 'provider_id' : 'vehicle_id';

switch ($method) {
    case 'POST':
        // Update location
        requireJWT();
        $id = (int)$input[$id_key] ?? 0;
        $latitude = (float)$input['latitude'] ?? 0.0;
        $longitude = (float)$input['longitude'] ?? 0.0;

        if (!$id || !$latitude || !$longitude) {
            $response->json(['error' => 'Missing ' . $id_key . ', latitude, or longitude'], 400);
        }

        $stmt = $conn_panic->prepare("
            INSERT INTO $table ($id_key, latitude, longitude, updated_at)
            VALUES (?, ?, ?, NOW())
            ON DUPLICATE KEY UPDATE latitude = ?, longitude = ?, updated_at = NOW()
        ");
        $stmt->bind_param('idddd', $id, $latitude, $longitude, $latitude, $longitude);
        if ($stmt->execute()) {
            $response->json(['success' => true, 'message' => ucfirst($type) . ' location updated'], 200);
        } else {
            $response->json(['success' => false, 'message' => $stmt->error], 500);
        }
        $stmt->close();
        break;

    case 'GET':
        // Get location(s)
        $id = (int)$_GET['id'] ?? 0;
        if ($id) {
            $stmt = $conn_panic->prepare("SELECT * FROM $table WHERE $id_key = ? ORDER BY updated_at DESC LIMIT 1");
            $stmt->bind_param('i', $id);
        } else {
            $stmt = $conn_panic->prepare("SELECT * FROM $table ORDER BY updated_at DESC LIMIT 50"); // Paginate if needed
        }
        $stmt->execute();
        $result = $stmt->get_result();
        $locations = [];
        while ($row = $result->fetch_assoc()) {
            $locations[] = $row;
        }
        $stmt->close();
        $response->json($locations, 200);
        break;

    default:
        $response->json(['error' => 'Method not allowed'], 405);
}