<?php
// File name: vitals.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/vitals.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        consultation_id,
        bp_site,
        bp_sys,
        bp_dia,
        bp_unit,
        cvp_site,
        cvp_value,
        cvp_unit,
        oxygen_saturation,
        respiration_rate,
        pulse,
        temperature,
        temperature_unit,
        temperature_site,
        device_id,
        validation_status,
        validation_reason,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        flagged_as_error,
        error_notes,
        error_flagged_by_user_id,
        error_flagged_by_role_type,
        error_flagged_at,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason,
        map  -- Mean Arterial Pressure
    FROM vital_signs 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY recorded_at DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$vitals = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['error_flagged_at'] = $row['error_flagged_at'] ? date('Y-m-d H:i:s', strtotime($row['error_flagged_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $vitals[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalVitals' => count($vitals),
    'vitals' => $vitals,
    'retrievedAt' => date('c')
]);
?>