<?php
// File name: vaccinations.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/vaccinations.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        vh.id,
        vh.vaccination_type,
        vh.vaccine_name,
        vh.dose,
        vh.frequency,
        vh.route,
        vh.batch_number,
        vh.facility_name,
        vh.vaccination_date,
        vh.side_effects,
        vh.follow_up_notes,
        vh.sideEffects_description,
        vh.severity,
        vh.notes,
        vh.follow_up_required,
        vh.follow_up_date,
        vh.booster_required,
        vh.administered_by_user_id,
        vh.administered_by_role_type,
        vh.administered_at,
        vh.validation_status,
        vh.validated_by_user_id,
        vh.validated_by_role_type,
        vh.validated_at,
        vh.validation_reason,
        vh.flagged_as_error,
        vh.error_notes,
        vh.recorded_by_user_id,
        vh.recorded_by_role_type,
        vh.recorded_at,
        vh.updated_by_user_id,
        vh.updated_by_role_type,
        vh.updated_at,
        vh.update_reason
    FROM vaccinations_history vh
    WHERE vh.patient_id = ?
      AND vh.deleted_at IS NULL
    ORDER BY vh.vaccination_date DESC, vh.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$vaccinations = [];
while ($row = $result->fetch_assoc()) {
    $vaccination_id = $row['id'];

    // Format main vaccination dates
    $row['vaccination_date'] = $row['vaccination_date'] ? date('Y-m-d', strtotime($row['vaccination_date'])) : null;
    $row['follow_up_date'] = $row['follow_up_date'] ? date('Y-m-d', strtotime($row['follow_up_date'])) : null;
    $row['administered_at'] = $row['administered_at'] ? date('Y-m-d H:i:s', strtotime($row['administered_at'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    // Fetch boosters separately
    $booster_stmt = $conn->prepare("
        SELECT 
            id,
            booster_date,
            dose,
            frequency,
            route,
            side_effects,
            follow_up_notes,
            administered_by_user_id,
            administered_by_role_type,
            administered_at,
            validation_status,
            validated_at,
            recorded_at,
            updated_at
        FROM vaccination_boosters_history 
        WHERE vaccination_history_id = ? 
          AND deleted_at IS NULL
        ORDER BY booster_date DESC
    ");
    if ($booster_stmt) {
        $booster_stmt->bind_param("i", $vaccination_id);
        $booster_stmt->execute();
        $booster_result = $booster_stmt->get_result();

        $boosters = [];
        while ($b_row = $booster_result->fetch_assoc()) {
            $b_row['booster_date'] = $b_row['booster_date'] ? date('Y-m-d', strtotime($b_row['booster_date'])) : null;
            $b_row['administered_at'] = $b_row['administered_at'] ? date('Y-m-d H:i:s', strtotime($b_row['administered_at'])) : null;
            $b_row['validated_at'] = $b_row['validated_at'] ? date('Y-m-d H:i:s', strtotime($b_row['validated_at'])) : null;
            $b_row['recorded_at'] = $b_row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($b_row['recorded_at'])) : null;
            $b_row['updated_at'] = $b_row['updated_at'] ? date('Y-m-d H:i:s', strtotime($b_row['updated_at'])) : null;

            $boosters[] = $b_row;
        }
        $booster_stmt->close();
    } else {
        $boosters = [];
    }

    $row['boosters'] = $boosters;
    $vaccinations[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalVaccinations' => count($vaccinations),
    'vaccinations' => $vaccinations,
    'retrievedAt' => date('c')
]);
?>