<?php
// File name: urological_history.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/urological_history.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        history_of_urinary_tract_infections,
        uti_details,
        number_of_urinary_tract_infections,
        history_of_kidney_stones,
        kidney_stones_details,
        kidney_stone_type,
        other_kidney_stone_type,
        history_of_prostate_disorders,
        prostate_disorders_details,
        prostate_disorder_type,
        other_prostate_disorder_type,
        history_of_bladder_disorders,
        bladder_disorders_details,
        bladder_disorder_type,
        other_bladder_disorder_type,
        history_of_incontinence,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM urological_history 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY recorded_at DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$urological_history = [];
while ($row = $result->fetch_assoc()) {
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $urological_history[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($urological_history),
    'urologicalHistory' => $urological_history,
    'retrievedAt' => date('c')
]);
?>