<?php
// File name: social_history.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/social_history.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        consultation_id,
        alcohol_use,
        alcohol_duration,
        alcohol_type,
        alcohol_type_other,
        alcohol_amount_per_week,
        smoking_status,
        smoking_pack_years,
        smoking_duration,
        vaping_status,
        vaping_duration,
        recreational_drug_use,
        drug_types,
        drug_types_other,
        sleep_pattern,
        sleep_pattern_other,
        sleep_duration_hours,
        sleep_quality,
        marital_status,
        marital_status_other,
        living_arrangements,
        living_arrangements_other,
        family_support,
        social_activities,
        travel_history,
        travel_destinations,
        occupational_exposure,
        occupational_exposure_details,
        environmental_exposure,
        environmental_exposure_details,
        home_environment,
        home_environment_other,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM social_history 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY recorded_at DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$social_history = [];
while ($row = $row = $result->fetch_assoc()) {
    // Convert SET fields to arrays
    $row['alcohol_type'] = $row['alcohol_type'] ? explode(',', $row['alcohol_type']) : [];
    $row['drug_types'] = $row['drug_types'] ? explode(',', $row['drug_types']) : [];

    // Format dates
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $social_history[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($social_history),
    'socialHistory' => $social_history,
    'retrievedAt' => date('c')
]);
?>