<?php
// File name: self_assessments.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/self_assessments.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        sa.id,
        sa.recorded_at,
        sa.notes,
        sa.recorded_by_user_id,
        sa.recorded_by_role_type,
        sa.updated_by_user_id,
        sa.updated_by_role_type,
        sa.updated_at,
        sa.update_reason,
        -- Anthropometry
        anth.height,
        anth.height_unit,
        anth.weight,
        anth.weight_unit,
        anth.bmi,
        anth.waist_circumference,
        anth.waist_circumference_unit,
        anth.hip_circumference,
        anth.waist_to_hip_ratio,
        anth.waist_to_height_ratio,
        anth.body_fat_percentage,
        anth.visceral_fat_percentage,
        anth.measurement_date AS anth_measurement_date,
        -- Blood Glucose
        bg.fasting_glucose,
        bg.postprandial_glucose,
        bg.random_glucose,
        bg.glucose_unit,
        bg.measurement_date AS bg_measurement_date,
        -- Vitals
        vit.temperature,
        vit.temperature_unit,
        vit.heart_rate,
        vit.respiratory_rate,
        vit.oxygen_saturation,
        -- BP Readings
        bp.site AS bp_site,
        bp.systolic,
        bp.diastolic,
        bp.map,
        -- Menstrual Cycle
        mc.cycle_start_date,
        mc.cycle_end_date,
        mc.cycle_length,
        mc.flow_intensity,
        mc.pain_level,
        mc.specific_symptoms,
        mc.medications,
        mc.bleeding_days,
        -- TB Screening
        tb.persistent_cough,
        tb.cough_duration_weeks,
        tb.coughing_blood,
        tb.chest_pain,
        tb.weight_loss,
        tb.weight_loss_amount,
        tb.weight_loss_unit,
        tb.night_sweats,
        tb.fever,
        tb.fatigue,
        tb.loss_appetite,
        tb.tb_contact,
        tb.smoking,
        tb.hiv_status,
        tb.assessment_date AS tb_assessment_date,
        tb.location_lat,
        tb.location_lon
    FROM self_assessments sa
    LEFT JOIN self_assessments_anthropometry anth ON sa.id = anth.self_assessment_id AND anth.deleted_at IS NULL
    LEFT JOIN self_assessments_blood_glucose bg ON sa.id = bg.self_assessment_id AND bg.deleted_at IS NULL
    LEFT JOIN self_assessments_vitals vit ON sa.id = vit.self_assessment_id AND vit.deleted_at IS NULL
    LEFT JOIN self_assessments_bp_readings bp ON vit.id = bp.self_assessments_vitals_id AND bp.deleted_at IS NULL
    LEFT JOIN self_assessments_menstrual_cycle mc ON sa.id = mc.self_assessment_id AND mc.deleted_at IS NULL
    LEFT JOIN self_assessments_tb tb ON sa.id = tb.self_assessment_id AND tb.deleted_at IS NULL
    WHERE sa.patient_id = ?
      AND sa.deleted_at IS NULL
    ORDER BY sa.recorded_at DESC, sa.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$assessments = [];
while ($row = $result->fetch_assoc()) {
    // Format main recorded_at
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    // Format sub-tables
    $row['anth_measurement_date'] = $row['anth_measurement_date'] ? date('Y-m-d', strtotime($row['anth_measurement_date'])) : null;
    $row['bg_measurement_date'] = $row['bg_measurement_date'] ? date('Y-m-d', strtotime($row['bg_measurement_date'])) : null;
    $row['tb_assessment_date'] = $row['tb_assessment_date'] ? date('Y-m-d', strtotime($row['tb_assessment_date'])) : null;
    $row['cycle_start_date'] = $row['cycle_start_date'] ? date('Y-m-d', strtotime($row['cycle_start_date'])) : null;
    $row['cycle_end_date'] = $row['cycle_end_date'] ? date('Y-m-d', strtotime($row['cycle_end_date'])) : null;

    $assessments[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalAssessments' => count($assessments),
    'selfAssessments' => $assessments,
    'retrievedAt' => date('c')
]);
?>