<?php
// File name: procedures.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/procedures.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        p.id,
        p.consultation_id,
        p.procedure_name,
        p.procedure_coding_system_id,
        p.procedure_code_id,
        p.provider_id,
        p.description,
        p.date_performed,
        p.result,
        p.complications,
        p.is_history,
        p.start_time,
        p.end_time,
        p.status,
        p.malampati_score_id,
        p.thyromental_distance,
        p.neck_mobility_id,
        p.mouth_opening_id,
        p.jaw_protrusion_id,
        p.dental_conditions,
        p.airway_obstruction,
        p.previous_intubation_attempts,
        p.difficult_airway_history,
        p.notes,
        p.validation_status,
        p.validated_by_user_id,
        p.validated_by_role_type,
        p.validated_at,
        p.validation_reason,
        p.flagged_as_error,
        p.error_notes,
        p.recorded_by_user_id,
        p.recorded_by_role_type,
        p.recorded_at,
        p.updated_by_user_id,
        p.updated_by_role_type,
        p.updated_at,
        p.update_reason,
        p.duration
    FROM procedures p
    WHERE p.patient_id = ?
      AND p.deleted_at IS NULL
    ORDER BY p.date_performed DESC, p.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$procedures = [];
while ($row = $result->fetch_assoc()) {
    $procedure_id = $row['id'];

    // Format dates
    $row['date_performed'] = $row['date_performed'] ? date('Y-m-d', strtotime($row['date_performed'])) : null;
    $row['start_time'] = $row['start_time'] ? date('Y-m-d H:i:s', strtotime($row['start_time'])) : null;
    $row['end_time'] = $row['end_time'] ? date('Y-m-d H:i:s', strtotime($row['end_time'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    // Fetch anaesthesia records for this procedure
    $anaesthesia_stmt = $conn->prepare("
        SELECT 
            id,
            anaesthesia_type_id,
            dosage,
            start_time,
            end_time,
            notes
        FROM anaesthesia_records 
        WHERE procedure_id = ?
          AND deleted_at IS NULL
    ");
    $anaesthesia_stmt->bind_param("i", $procedure_id);
    $anaesthesia_stmt->execute();
    $anaesthesia_result = $anaesthesia_stmt->get_result();

    $anaesthesia = [];
    while ($a_row = $anaesthesia_result->fetch_assoc()) {
        $a_row['start_time'] = $a_row['start_time'] ? date('Y-m-d H:i:s', strtotime($a_row['start_time'])) : null;
        $a_row['end_time'] = $a_row['end_time'] ? date('Y-m-d H:i:s', strtotime($a_row['end_time'])) : null;
        $anaesthesia[] = $a_row;
    }
    $anaesthesia_stmt->close();

    $row['anaesthesia'] = $anaesthesia;

    // Fetch procedure providers
    $providers_stmt = $conn->prepare("
        SELECT 
            id,
            provider_id,
            user_role_description_id
        FROM procedure_providers 
        WHERE procedure_id = ?
          AND deleted_at IS NULL
    ");
    $providers_stmt->bind_param("i", $procedure_id);
    $providers_stmt->execute();
    $providers_result = $providers_stmt->get_result();

    $providers = [];
    while ($pr_row = $providers_result->fetch_assoc()) {
        $providers[] = $pr_row;
    }
    $providers_stmt->close();

    $row['providers'] = $providers;

    // Fetch procedure code details
    $code_stmt = $conn->prepare("
        SELECT 
            code,
            code_description
        FROM procedural_codes 
        WHERE id = ?
    ");
    $code_stmt->bind_param("i", $row['procedure_code_id']);
    $code_stmt->execute();
    $code_result = $code_stmt->get_result();
    $row['procedure_code'] = $code_result->fetch_assoc() ?? [];
    $code_stmt->close();

    $procedures[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalProcedures' => count($procedures),
    'procedures' => $procedures,
    'retrievedAt' => date('c')
]);
?>