<?php
// File name: haematology_history.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/haematology_history.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        hh.id,
        hh.blood_group,
        hh.rh_factor,
        hh.blood_group_test_date,
        hh.transfusion_history,
        hh.last_transfusion_date,
        hh.transfusion_type,
        hh.transfusion_reactions,
        hh.transfusion_reaction_details,
        hh.has_bleeding_disorder,
        hh.bleeding_disorder_type,
        hh.bleeding_disorder_type_other,
        hh.refuses_transfusion,
        hh.transfusion_refusal_reason,
        hh.transfusion_refusal_reason_other,
        hh.active_treatment_type,
        hh.active_treatment_regimen,
        hh.active_treatment_start_date,
        hh.active_treatment_end_date,
        hh.active_treatment_side_effects,
        hh.active_treatment_side_effects_other,
        hh.validation_status,
        hh.validated_by_user_id,
        hh.validated_by_role_type,
        hh.validated_at,
        hh.validation_reason,
        hh.recorded_by_user_id,
        hh.recorded_by_role_type,
        hh.recorded_at,
        hh.updated_by_user_id,
        hh.updated_by_role_type,
        hh.updated_at,
        hh.update_reason
    FROM haematology_history hh
    WHERE hh.patient_id = ?
      AND hh.deleted_at IS NULL
    ORDER BY hh.recorded_at DESC, hh.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$haematology = [];
while ($row = $result->fetch_assoc()) {
    $history_id = $row['id'];

    // Format dates
    $row['blood_group_test_date'] = $row['blood_group_test_date'] ? date('Y-m-d', strtotime($row['blood_group_test_date'])) : null;
    $row['last_transfusion_date'] = $row['last_transfusion_date'] ? date('Y-m-d', strtotime($row['last_transfusion_date'])) : null;
    $row['active_treatment_start_date'] = $row['active_treatment_start_date'] ? date('Y-m-d', strtotime($row['active_treatment_start_date'])) : null;
    $row['active_treatment_end_date'] = $row['active_treatment_end_date'] ? date('Y-m-d', strtotime($row['active_treatment_end_date'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    // Convert SET fields to arrays
    $row['transfusion_type'] = $row['transfusion_type'] ? explode(',', $row['transfusion_type']) : [];
    $row['bleeding_disorder_type'] = $row['bleeding_disorder_type'] ? explode(',', $row['bleeding_disorder_type']) : [];
    $row['transfusion_refusal_reason'] = $row['transfusion_refusal_reason'] ? explode(',', $row['transfusion_refusal_reason']) : [];
    $row['active_treatment_type'] = $row['active_treatment_type'] ? explode(',', $row['active_treatment_type']) : [];
    $row['active_treatment_side_effects'] = $row['active_treatment_side_effects'] ? explode(',', $row['active_treatment_side_effects']) : [];

    // Fetch previous treatments
    $treat_stmt = $conn->prepare("
        SELECT 
            treatment_type,
            treatment_type_other,
            regimen,
            start_date,
            end_date,
            side_effects,
            side_effects_other
        FROM haematology_previous_treatments 
        WHERE haematology_history_id = ?
          AND deleted_at IS NULL
    ");
    $treat_stmt->bind_param("i", $history_id);
    $treat_stmt->execute();
    $treat_result = $treat_stmt->get_result();

    $treatments = [];
    while ($t_row = $treat_result->fetch_assoc()) {
        $t_row['treatment_type'] = $t_row['treatment_type'] ? explode(',', $t_row['treatment_type']) : [];
        $t_row['side_effects'] = $t_row['side_effects'] ? explode(',', $t_row['side_effects']) : [];
        $t_row['start_date'] = $t_row['start_date'] ? date('Y-m-d', strtotime($t_row['start_date'])) : null;
        $t_row['end_date'] = $t_row['end_date'] ? date('Y-m-d', strtotime($t_row['end_date'])) : null;
        $treatments[] = $t_row;
    }
    $treat_stmt->close();

    $row['previousTreatments'] = $treatments;
    $haematology[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($haematology),
    'haematologyHistory' => $haematology,
    'retrievedAt' => date('c')
]);
?>