<?php
// File name: communication_sessions.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/communication_sessions.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

// NOTE: communication_sessions has NO deleted_at column — removed from WHERE
$stmt = $conn->prepare("
    SELECT 
        cs.id,
        cs.consultation_id,
        cs.session_type,
        cs.platform,
        cs.room_name,
        cs.status,
        cs.scheduled_time,
        cs.start_time,
        cs.end_time,
        cs.duration_seconds,
        cs.total_participant_seconds,
        cs.recording_url,
        cs.cost,
        cs.cost_currency,
        cs.billing_status,
        cs.recording_enabled,
        cs.recording_cost,
        cs.outcome_notes,
        cs.invitation_link,
        cs.call_type
    FROM communication_sessions cs
    JOIN consultations c ON cs.consultation_id = c.id
    WHERE c.patient_id = ?
    ORDER BY cs.scheduled_time DESC, cs.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$sessions = [];
while ($row = $result->fetch_assoc()) {
    $session_id = $row['id'];

    // Format times
    $row['scheduled_time'] = $row['scheduled_time'] ? date('Y-m-d H:i:s', strtotime($row['scheduled_time'])) : null;
    $row['start_time'] = $row['start_time'] ? date('Y-m-d H:i:s', strtotime($row['start_time'])) : null;
    $row['end_time'] = $row['end_time'] ? date('Y-m-d H:i:s', strtotime($row['end_time'])) : null;

    // Fetch participants (safe — no deleted_at here either)
    $part_stmt = $conn->prepare("
        SELECT 
            user_id,
            role_type,
            join_time,
            leave_time,
            duration_seconds,
            billing_status,
            customer_charge,
            charge_currency,
            connection_quality
        FROM communication_session_participants 
        WHERE session_id = ?
    ");
    $part_stmt->bind_param("i", $session_id);
    $part_stmt->execute();
    $part_result = $part_stmt->get_result();

    $participants = [];
    while ($p_row = $part_result->fetch_assoc()) {
        $p_row['join_time'] = $p_row['join_time'] ? date('Y-m-d H:i:s', strtotime($p_row['join_time'])) : null;
        $p_row['leave_time'] = $p_row['leave_time'] ? date('Y-m-d H:i:s', strtotime($p_row['leave_time'])) : null;
        $participants[] = $p_row;
    }
    $part_stmt->close();

    $row['participants'] = $participants;
    $sessions[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalSessions' => count($sessions),
    'communicationSessions' => $sessions,
    'retrievedAt' => date('c')
]);
?>