<?php
// File name: orders.php
// File location: /home/apimedi1/public_html/api/v1/routes/lab/orders.php
require_once __DIR__ . '/../../middleware/jwt.php';

$method = $_SERVER['REQUEST_METHOD'];

requireJWT();

// Retrieve payload to get region (for non-patient specific)
$header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
preg_match('/Bearer\s+(\S+)/', $header, $matches);
$payload = validateJWT($matches[1] ?? '');
$user_region = $payload['regionCode'] ?? 'NA';
$auth_user_id = $GLOBALS['auth_user_id'];

if ($method === 'POST') {
    $data = getJsonInput();
    $patient_id = $data['patient_id'] ?? 0;
    $partner_id = $data['partner_id'] ?? null;
    $facility_id = $data['facility_id'] ?? null;
    $partner_type = $data['partner_type'] ?? 'Lab';
    $collection_location_note = $data['collection_location_note'] ?? null;
    $collected_tests = json_encode($data['collected_tests'] ?? []);
    $collected_tubes = json_encode($data['collected_tubes'] ?? []);

    if (!$patient_id) {
        (new Response)->json(['error' => 'Patient ID required'], 400);
    }

    $region = getPatientRegion($patient_id);
    $conn = getDatabaseConnection('lab_tests', $region);

    if (!$conn) {
        (new Response)->json(['error' => 'Database connection failed'], 500);
    }

    $stmt = $conn->prepare("
        INSERT INTO lab_test_orders 
        (patient_id, ordering_provider_id, partner_id, facility_id, partner_type, 
         collection_location_note, collected_tests, collected_tubes)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        (new Response)->json(['error' => 'Query preparation failed: ' . $conn->error], 500);
    }

    $stmt->bind_param("iiiissss", $patient_id, $auth_user_id, $partner_id, $facility_id, $partner_type, 
                      $collection_location_note, $collected_tests, $collected_tubes);
    if ($stmt->execute()) {
        $order_id = $stmt->insert_id;
        (new Response)->json(['message' => 'Order created', 'order_id' => $order_id], 201);
    } else {
        (new Response)->json(['error' => 'Order creation failed: ' . $stmt->error], 500);
    }
    $stmt->close();
} elseif ($method === 'GET') {
    $patient_id = $_GET['patient_id'] ?? 0;
    $order_id = $_GET['order_id'] ?? 0;

    if (!$patient_id && !$order_id) {
        (new Response)->json(['error' => 'Patient ID or Order ID required'], 400);
    }

    $region = $patient_id ? getPatientRegion($patient_id) : $user_region;
    $conn = getDatabaseConnection('lab_tests', $region);

    if (!$conn) {
        (new Response)->json(['error' => 'Database connection failed'], 500);
    }

    if ($order_id) {
        $stmt = $conn->prepare("SELECT * FROM lab_test_orders WHERE id = ? AND is_deleted = 0");
        $stmt->bind_param("i", $order_id);
    } else {
        $stmt = $conn->prepare("SELECT * FROM lab_test_orders WHERE patient_id = ? AND is_deleted = 0 ORDER BY order_date DESC");
        $stmt->bind_param("i", $patient_id);
    }

    if (!$stmt) {
        (new Response)->json(['error' => 'Query preparation failed: ' . $conn->error], 500);
    }

    $stmt->execute();
    $result = $stmt->get_result();
    $orders = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    (new Response)->json($orders);
} else {
    (new Response)->json(['error' => 'Method Not Allowed'], 405);
}
?>