<?php
// File name: full.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/full.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMainRegion = getDatabaseConnection('main', $regionCode);
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);
$connPrescriptions = getDatabaseConnection('prescriptions', $regionCode);
$connMedications = getDatabaseConnection('medications', $regionCode);

if (!$connMainGlobal || !$connMainRegion || !$connMedicalRegion || !$connPrescriptions || !$connMedications) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch all QR visibilities
$sqlQr = "SELECT * FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

// Check if any visibility is 0; deny if restricted
$deniedSections = [];
foreach ($qrRow as $key => $val) {
    if (strpos($key, 'visibility_') === 0 && $val == 0) {
        $deniedSections[] = str_replace('visibility_', '', $key);
    }
}
if (!empty($deniedSections)) {
    (new Response)->json(['error' => 'Access denied to sections: ' . implode(', ', $deniedSections)], 403);
}

$fullData = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND deleted_at IS NULL AND validation_status='Validated'" : " AND deleted_at IS NULL";

// Profile
$userProfile = [];
$sqlUser = "SELECT u.title, u.first_name, u.last_name, u.race, u.gender, ua.country, u.date_of_birth 
            FROM users u LEFT JOIN user_addresses ua ON u.id = ua.user_id 
            WHERE u.id = (SELECT user_id FROM patients WHERE id = ?) AND u.deleted_at IS NULL LIMIT 1";
$stmtUser = $connMainRegion->prepare($sqlUser);
$stmtUser->bind_param('i', $patientId);
$stmtUser->execute();
$rU = $stmtUser->get_result();
if ($urow = $rU->fetch_assoc()) {
    $userProfile = $urow;
}
$stmtUser->close();

$profilePhotoUrl = '';
$sqlProfilePic = "SELECT profile_pic FROM patients WHERE id = ? AND deleted_at IS NULL LIMIT 1";
$stmtProfilePic = $connMainRegion->prepare($sqlProfilePic);
$stmtProfilePic->bind_param('i', $patientId);
$stmtProfilePic->execute();
$result = $stmtProfilePic->get_result();
if ($row = $result->fetch_assoc()) {
    $profilePhotoUrl = $row['profile_pic'] ?: '/images/icons/user-placeholder.png';
}
$stmtProfilePic->close();

$age = null;
if (!empty($userProfile['date_of_birth'])) {
    $dob = new DateTime($userProfile['date_of_birth']);
    $now = new DateTime();
    $age = $now->diff($dob)->y;
}
$userProfile['age'] = $age;
$userProfile['profile_photo_url'] = $profilePhotoUrl;
$fullData['profile'] = $userProfile;

// Haematology
$haema = null;
$sqlHaema = "SELECT blood_group, rh_factor, blood_group_test_date, transfusion_history, last_transfusion_date, transfusion_type, transfusion_reactions 
             FROM haematology_history WHERE patient_id=? $where ORDER BY recorded_at DESC LIMIT 1";
$stmH = $connMedicalRegion->prepare($sqlHaema);
$stmH->bind_param('i', $patientId);
$stmH->execute();
$rH = $stmH->get_result();
if ($rowH = $rH->fetch_assoc()) {
    $haema = $rowH;
}
$stmH->close();
$fullData['haematology'] = $haema;

// Allergies
$allergies = [];
$epinephrineGlobal = 'No';
$sqlAll = "SELECT allergen_name, reaction_severity, last_occurrence, emergency_plan, emergency_plan_details, emergency_protocols, epinephrine_carried 
           FROM allergy_history WHERE patient_id=? $where ORDER BY system_created_at DESC";
$stmA = $connMedicalRegion->prepare($sqlAll);
$stmA->bind_param('i', $patientId);
$stmA->execute();
$ra = $stmA->get_result();
while ($ar = $ra->fetch_assoc()) {
    if (strtolower($ar['epinephrine_carried']) === 'yes') {
        $epinephrineGlobal = 'Yes';
    }
    $allergies[] = $ar;
}
$stmA->close();
$fullData['allergies'] = ['epinephrine_carried' => $epinephrineGlobal, 'allergies' => $allergies];

// Diagnoses
$diagnoses = [];
$sqlDiag = "SELECT d.id, d.diagnosis_date, d.diagnosis_code, cs.system_name, d.diagnosis_description, d.diagnosis_type, d.severity, d.diagnosis_confirmation 
            FROM diagnoses d LEFT JOIN coding_systems cs ON d.coding_system_id=cs.id 
            WHERE d.patient_id=? $where ORDER BY d.diagnosis_date DESC";
$stmD = $connMedicalRegion->prepare($sqlDiag);
$stmD->bind_param('i', $patientId);
$stmD->execute();
$rd = $stmD->get_result();
while ($dx = $rd->fetch_assoc()) {
    $diagId = (int)$dx['id'];
    $linkedPresc = [];
    $whereP = $onlyValidated ? " AND p.validation_status='Validated' AND pi.validation_status='Validated' AND pdl.validation_status='Validated'" : "";
    $sqlDiagPresc = "SELECT DISTINCT p.prescription_id, p.date_issued, p.status, p.notes 
                     FROM prescriptions p JOIN prescription_items pi ON p.prescription_id = pi.prescription_id 
                     JOIN prescription_diagnosis_link pdl ON pi.prescription_item_id = pdl.prescription_item_id 
                     WHERE p.patient_id = ? AND pdl.diagnosis_id = ? AND p.deleted_at IS NULL AND pdl.deleted_at IS NULL $whereP";
    $stmDiagPresc = $connPrescriptions->prepare($sqlDiagPresc);
    $stmDiagPresc->bind_param('ii', $patientId, $diagId);
    $stmDiagPresc->execute();
    $rdp = $stmDiagPresc->get_result();
    while ($dp = $rdp->fetch_assoc()) {
        $prescId = (int)$dp['prescription_id'];
        $items = [];
        $whereI = $onlyValidated ? " AND pi.validation_status='Validated'" : "";
        $sqlItems = "SELECT pi.drug_id, pi.dosage, pi.units, pi.frequency, pi.route, pi.duration, pi.duration_unit, pi.instructions 
                     FROM prescription_items pi WHERE pi.prescription_id=? AND pi.deleted_at IS NULL $whereI";
        $stmItems = $connPrescriptions->prepare($sqlItems);
        $stmItems->bind_param('i', $prescId);
        $stmItems->execute();
        $ri = $stmItems->get_result();
        while ($item = $ri->fetch_assoc()) {
            $drugName = 'Unknown';
            if ($item['drug_id']) {
                $drugId = (int)$item['drug_id'];
                $sqlDrug = "SELECT active_compound FROM drug_list WHERE drug_id=? LIMIT 1";
                $stmDrug = $connMedications->prepare($sqlDrug);
                $stmDrug->bind_param('i', $drugId);
                $stmDrug->execute();
                $rDrug = $stmDrug->get_result();
                if ($drugRow = $rDrug->fetch_assoc()) {
                    $drugName = $drugRow['active_compound'];
                }
                $stmDrug->close();
            }
            $item['drug_name'] = $drugName;
            $items[] = $item;
        }
        $stmItems->close();
        $dp['items'] = $items;
        $linkedPresc[] = $dp;
    }
    $stmDiagPresc->close();
    $dx['prescriptions'] = $linkedPresc;
    $diagnoses[] = $dx;
}
$stmD->close();
$fullData['diagnoses'] = $diagnoses;

// Facility Admissions
$admissions = [];
$sqlFA = "SELECT admission_date, discharge_date, facility_id, reason_for_admission, treatment_plan 
          FROM facility_admissions WHERE patient_id=? $where ORDER BY admission_date DESC";
$stmtFA = $connMedicalRegion->prepare($sqlFA);
$stmtFA->bind_param('i', $patientId);
$stmtFA->execute();
$resFA = $stmtFA->get_result();
while ($fa = $resFA->fetch_assoc()) {
    $facilityName = 'Unknown';
    if ($fa['facility_id']) {
        $sqlFacility = "SELECT facility_name FROM facilities WHERE facility_id=? LIMIT 1";
        $stmtFacility = $connMainGlobal->prepare($sqlFacility);
        $stmtFacility->bind_param('i', $fa['facility_id']);
        $stmtFacility->execute();
        $resFacility = $stmtFacility->get_result();
        if ($rowFacility = $resFacility->fetch_assoc()) {
            $facilityName = $rowFacility['facility_name'];
        }
        $stmtFacility->close();
    }
    $fa['facility_name'] = $facilityName;
    $admissions[] = $fa;
}
$stmtFA->close();
$fullData['facility_admissions'] = $admissions;

// STI History
$stis = [];
$sqlSTI = "SELECT sh.id, st.type_name as sti_name, sh.diagnosis_status, sh.diagnosis_date, sh.treatment_status, sh.treatment_details 
           FROM sti_history sh LEFT JOIN sti_types st ON sh.sti_type_id=st.id 
           WHERE sh.patient_id=? $where ORDER BY sh.system_created_at DESC";
$stmS = $connMedicalRegion->prepare($sqlSTI);
$stmS->bind_param('i', $patientId);
$stmS->execute();
$rs = $stmS->get_result();
while ($srow = $rs->fetch_assoc()) {
    $stis[] = $srow;
}
$stmS->close();
$fullData['sti_history'] = $stis;

// Travel History
$travels = [];
$sqlTravel = "SELECT destination_country, start_date, end_date, purpose_of_travel, additional_notes as notes 
              FROM travel_history WHERE patient_id=? $where ORDER BY system_created_at DESC";
$stmT = $connMedicalRegion->prepare($sqlTravel);
$stmT->bind_param('i', $patientId);
$stmT->execute();
$rt = $stmT->get_result();
while ($tr = $rt->fetch_assoc()) {
    $travels[] = $tr;
}
$stmT->close();
$fullData['travel_history'] = $travels;

// Emergency Contacts
$emContacts = [];
$sqlEC = "SELECT ec.first_name, ec.last_name, lr.relationship_name, ec.phone_number, ec.is_primary_contact 
          FROM emergency_contacts ec LEFT JOIN lookup_relationships lr ON ec.relationship_id=lr.id 
          WHERE ec.patient_id=? $where ORDER BY ec.system_created_at DESC";
$stmEC = $connMedicalRegion->prepare($sqlEC);
$stmEC->bind_param('i', $patientId);
$stmEC->execute();
$rec = $stmEC->get_result();
while ($er = $rec->fetch_assoc()) {
    $emContacts[] = $er;
}
$stmEC->close();
$fullData['emergency_contacts'] = $emContacts;

// Vaccinations
$vaccinations = [];
$whereV = $onlyValidated ? " AND vh.validation_status='Validated'" : "";
$sqlVacc = "SELECT vh.id, vh.vaccination_type, vh.vaccination_date, vh.vaccine_name, vh.dose, vh.frequency, vh.route 
            FROM vaccinations_history vh WHERE vh.patient_id=? AND vh.deleted_at IS NULL $whereV ORDER BY vh.vaccination_date DESC";
$stmVacc = $connMedicalRegion->prepare($sqlVacc);
$stmVacc->bind_param('i', $patientId);
$stmVacc->execute();
$rv = $stmVacc->get_result();
while ($vac = $rv->fetch_assoc()) {
    $vaccId = (int)$vac['id'];
    $boosters = [];
    $whereB = $onlyValidated ? " AND vb.validation_status='Validated'" : "";
    $sqlBoost = "SELECT vb.booster_date, vb.dose, vb.frequency, vb.route, vb.side_effects 
                 FROM vaccination_boosters_history vb WHERE vb.vaccination_history_id=? AND vb.deleted_at IS NULL $whereB";
    $stmBoost = $connMedicalRegion->prepare($sqlBoost);
    $stmBoost->bind_param('i', $vaccId);
    $stmBoost->execute();
    $rb = $stmBoost->get_result();
    while ($bst = $rb->fetch_assoc()) {
        $boosters[] = $bst;
    }
    $stmBoost->close();
    $vac['boosters'] = $boosters;
    $vaccinations[] = $vac;
}
$stmVacc->close();
$fullData['vaccinations'] = $vaccinations;

// Health Insurance
$healthIns = [];
$sqlHI = "SELECT medical_aid_name, medical_aid_number, medical_aid_plan, main_member, dependant_code 
          FROM health_insurance_history WHERE patient_id=? $where ORDER BY id DESC LIMIT 1";
$stmHI = $connMedicalRegion->prepare($sqlHI);
$stmHI->bind_param('i', $patientId);
$stmHI->execute();
$rHI = $stmHI->get_result();
if ($hi = $rHI->fetch_assoc()) {
    $healthIns = $hi;
}
$stmHI->close();
$fullData['health_insurance'] = $healthIns;

(new Response)->json($fullData, 200);
?>