<?php
// File name: invoices.php
// File location: /home/apimedi1/public_html/api/v1/routes/billing/invoices.php

requireJWT();
$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();
$user_id = $GLOBALS['auth_user_id'];

switch ($method) {
    case 'GET':
        if (preg_match('#^billing/invoices/(\d+)$#', $uri, $m)) {
            // Get specific invoice
            $inv_id = (int)$m[1];
            $conn_billing = getConnBilling();
            $stmt = $conn_billing->prepare("SELECT * FROM invoices WHERE id = ? AND user_id = ?");
            $stmt->bind_param("ii", $inv_id, $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            if ($row = $result->fetch_assoc()) {
                $response->json($row);
            } else {
                $response->json(['error' => 'Invoice not found'], 404);
            }
        } else {
            // List invoices
            $conn_billing = getConnBilling();
            $stmt = $conn_billing->prepare("SELECT * FROM invoices WHERE user_id = ?");
            $stmt->bind_param("i", $user_id);
            $stmt->execute();
            $result = $stmt->get_result();
            $invoices = [];
            while ($row = $result->fetch_assoc()) {
                $invoices[] = $row;
            }
            $response->json($invoices);
        }
        break;

    default:
        $response->json(['error' => 'Method not allowed'], 405);
}