<?php
// File name: disputes.php
// File location: /home/apimedi1/public_html/api/v1/routes/billing/disputes.php

requireJWT();
$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();
$user_id = $GLOBALS['auth_user_id'];

switch ($method) {
    case 'GET':
        // List disputes
        $conn_billing = getConnBilling();
        $stmt = $conn_billing->prepare("SELECT * FROM disputes WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $disputes = [];
        while ($row = $result->fetch_assoc()) {
            $disputes[] = $row;
        }
        $response->json($disputes);
        break;

    case 'POST':
        // Create dispute
        $input = getJsonInput();
        $invoice_id = $input['invoice_id'] ?? null;
        $disputed_amount = $input['disputed_amount'] ?? null;
        $dispute_reason = $input['dispute_reason'] ?? null;

        if (!$invoice_id || !$disputed_amount || !$dispute_reason) {
            $response->json(['error' => 'Missing required fields'], 400);
        }

        $conn_billing = getConnBilling();
        $stmt = $conn_billing->prepare("INSERT INTO disputes (user_id, invoice_id, disputed_amount, dispute_reason, created_by_user_id) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("iidsi", $user_id, $invoice_id, $disputed_amount, $dispute_reason, $user_id);
        if ($stmt->execute()) {
            $response->json(['success' => true, 'dispute_id' => $stmt->insert_id]);
        } else {
            $response->json(['error' => 'Failed to create dispute'], 500);
        }
        break;

    default:
        $response->json(['error' => 'Method not allowed'], 405);
}