<?php
// File name: auth.php
// File location: /home/apimedi1/public_html/api/v1/routes/auth.php

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    (new Response)->json(['error' => 'Method Not Allowed'], 405);
}

$data = getJsonInput();
$email = $data['email'] ?? '';
$password = $data['password'] ?? '';
$requestedRoleType = ucfirst(strtolower(trim($data['role_type'] ?? ''))); // Normalize to title case (e.g., "Patient")
$requestedRole = ucwords(strtolower(trim($data['role'] ?? ''))); // Normalize to title case (e.g., "Facility Admin")

if (empty($email) || empty($password) || empty($requestedRoleType) || empty($requestedRole)) {
    (new Response)->json(['error' => 'Email, password, role_type, and role required'], 400);
}

$conn = getConnMain();
$stmt = $conn->prepare("
    SELECT u.id, u.password, u.account_status, u.base_currency, u.timezone, u.first_name, u.middle_name, u.last_name, u.title,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id LIMIT 1) AS region_code,
           (SELECT GROUP_CONCAT(DISTINCT urd.role_type) FROM user_roles ur JOIN user_role_descriptions urd ON ur.role_id = urd.id WHERE ur.user_id = u.id) AS role_types,
           (SELECT GROUP_CONCAT(DISTINCT urd.role) FROM user_roles ur JOIN user_role_descriptions urd ON ur.role_id = urd.id WHERE ur.user_id = u.id) AS roles,
           (SELECT GROUP_CONCAT(DISTINCT ur.tenant_id) FROM user_roles ur WHERE ur.user_id = u.id) AS tenant_ids,
           (SELECT GROUP_CONCAT(DISTINCT ur.organization_id) FROM user_roles ur WHERE ur.user_id = u.id) AS organization_ids,
           (SELECT GROUP_CONCAT(DISTINCT ur.facility_id) FROM user_roles ur WHERE ur.user_id = u.id) AS facility_ids,
           (SELECT GROUP_CONCAT(DISTINCT ur.entity_id) FROM user_roles ur WHERE ur.user_id = u.id) AS entity_ids,
           (SELECT patient_id FROM users WHERE id = u.id) AS patient_id,
           (SELECT provider_id FROM users WHERE id = u.id) AS provider_id,
           (SELECT GROUP_CONCAT(DISTINCT ur.partner_id) FROM user_roles ur WHERE ur.user_id = u.id) AS partner_ids,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id AND user_role_type = 'Patient' LIMIT 1) AS patient_region_code,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id AND user_role_type = 'Provider' LIMIT 1) AS provider_region_code,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id AND user_role_type = 'Partner' LIMIT 1) AS partner_region_code
    FROM users u WHERE email = ?
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    if (password_verify($password, $row['password'])) {
        $token = generateJWT($row['id'], $row['region_code'] ?? 'NA');

        // Full name construction
        $full_name = trim(($row['title'] ?? '') . ' ' . ($row['first_name'] ?? '') . ' ' . ($row['middle_name'] ?? '') . ' ' . ($row['last_name'] ?? ''));

        // Role types and roles as arrays
        $role_types = !empty($row['role_types']) ? array_unique(explode(',', $row['role_types'])) : [];
        $roles = !empty($row['roles']) ? array_unique(explode(',', $row['roles'])) : [];

        // Normalize stored role_types and roles to title case for comparison
        $role_types_normalized = array_map(function($rt) { return ucfirst(strtolower($rt)); }, $role_types);
        $roles_normalized = array_map(function($r) { return ucwords(strtolower($r)); }, $roles);

        // Validate requested role_type and role
        if (!in_array($requestedRoleType, $role_types_normalized)) {
            (new Response)->json(['error' => 'Invalid role_type – must be one of your assigned role_types'], 400);
        }
        if (!in_array($requestedRole, $roles_normalized)) {
            (new Response)->json(['error' => 'Invalid role – must be one of your assigned roles'], 400);
        }

        // Intelligent validation: Check if role matches role_type (query paired data)
        $validationStmt = $conn->prepare("
            SELECT 1 
            FROM user_roles ur
            JOIN user_role_descriptions urd ON ur.role_id = urd.id
            WHERE ur.user_id = ? AND urd.role_type = ? AND urd.role = ?
        ");
        $validationStmt->bind_param("iss", $row['id'], $requestedRoleType, $requestedRole);
        $validationStmt->execute();
        $validationResult = $validationStmt->get_result();
        if ($validationResult->num_rows === 0) {
            (new Response)->json(['error' => 'Role does not match the requested role_type'], 400);
        }
        $validationStmt->close();

        // Tenant, organization, facility, entity IDs as arrays (unique non-empty)
        $tenant_ids = !empty($row['tenant_ids']) ? array_unique(array_filter(explode(',', $row['tenant_ids']))) : [];
        $organization_ids = !empty($row['organization_ids']) ? array_unique(array_filter(explode(',', $row['organization_ids']))) : [];
        $facility_ids = !empty($row['facility_ids']) ? array_unique(array_filter(explode(',', $row['facility_ids']))) : [];
        $entity_ids = !empty($row['entity_ids']) ? array_unique(array_filter(explode(',', $row['entity_ids']))) : [];
        $partner_ids = !empty($row['partner_ids']) ? array_unique(array_filter(explode(',', $row['partner_ids']))) : [];

        // Fetch affiliate_id using getConnAffiliates()
        $affiliate_id = null;
        $conn_affiliates = getConnAffiliates();
        $aff_stmt = $conn_affiliates->prepare("SELECT affiliate_id FROM affiliates WHERE user_id = ? AND role_type = 'Partner' LIMIT 1");
        if ($aff_stmt) {
            $aff_stmt->bind_param("i", $row['id']);
            $aff_stmt->execute();
            $aff_stmt->bind_result($affiliate_id);
            $aff_stmt->fetch();
            $aff_stmt->close();
        }

        // Log the login to user_login_logs with detailed error handling
        $connAudit = getConnAudit();
        if (!$connAudit) {
            (new Response)->json(['error' => 'Audit database unavailable'], 500);
        }

        $sessionId = uniqid('api_session_', true); // Generate unique session ID for API
        $ipAddress = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';

$loginStmt = $connAudit->prepare("
    INSERT INTO user_login_logs
    (user_id, session_id, login_time, ip_address, user_agent, role, role_type, status, authentication_method)
    VALUES (?, ?, NOW(), ?, ?, ?, ?, 'successful', 'password')
");
        if (!$loginStmt) {
            (new Response)->json(['error' => 'Failed to prepare login log insert: ' . $connAudit->error], 500);
        }

        $loginStmt->bind_param("isssss", $row['id'], $sessionId, $ipAddress, $userAgent, $requestedRole, $requestedRoleType);
        if (!$loginStmt->execute()) {
            (new Response)->json(['error' => 'Failed to execute login log insert: ' . $loginStmt->error], 500);
        }
        $loginStmt->close();

        (new Response)->json([
            'token' => $token,
            'session_id' => $sessionId,
            'userId' => $row['id'],
            'regionCode' => $row['region_code'] ?? 'NA',
            'accountStatus' => $row['account_status'],
            'baseCurrency' => $row['base_currency'],
            'timezone' => $row['timezone'],
            'fullName' => $full_name,
            'roleTypes' => $role_types,
            'roles' => $roles,
            'tenantIds' => $tenant_ids,
            'organizationIds' => $organization_ids,
            'facilityIds' => $facility_ids,
            'entityIds' => $entity_ids,
            'patientId' => $row['patient_id'] ?? null,
            'patientRegionCode' => $row['patient_region_code'] ?? null,
            'providerId' => $row['provider_id'] ?? null,
            'providerRegionCode' => $row['provider_region_code'] ?? null,
            'partnerIds' => $partner_ids,
            'partnerRegionCode' => $row['partner_region_code'] ?? null,
            'affiliateId' => $affiliate_id ?? null,
            'message' => 'Login successful'
        ]);
    } else {
        (new Response)->json(['error' => 'Invalid credentials'], 401);
    }
} else {
    (new Response)->json(['error' => 'Invalid credentials'], 401);
}

$stmt->close();
?>