<?php
// File name: withdrawals.php
// File location: /home/apimedi1/public_html/api/v1/routes/affiliate/withdrawals.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

$user_id = requireJWT();
$user_id_str = (string)$user_id;
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';

$conn = getDatabaseConnection('affiliates', 'GBL');
if (!$conn) {
    logError('Database connection failed for affiliate withdrawals', 'Database', __FILE__, __LINE__);
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();

if (!isset($_GET['affiliate_id'])) {
    $response->json(['error' => 'Missing affiliate_id'], 400);
}
$aff_code = $_GET['affiliate_id'];

$stmt = $conn->prepare("SELECT affiliate_id FROM affiliates WHERE affiliate_id = ? AND user_id = ? AND deleted_at IS NULL");
$stmt->bind_param("ss", $aff_code, $user_id_str);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();
if (!$row) {
    $response->json(['error' => 'Affiliate not found or unauthorized'], 403);
}
$affiliate_id = $row['affiliate_id'];
$stmt->close();

switch ($method) {
    case 'POST':
        $input = getJsonInput();

        $bank_account_id = $input['bank_account_id'] ?? 0;
        $amount = $input['amount'] ?? 0.00;
        $transaction_currency = $input['currency'] ?? 'USD';
        $additional_notes = $input['additional_notes'] ?? null;

        if ($bank_account_id <= 0 || $amount <= 0) {
            $response->json(['error' => 'Invalid bank_account_id or amount'], 400);
        }

        $stmt = $conn->prepare("SELECT id FROM affiliate_bank_accounts WHERE id = ? AND affiliate_id = (SELECT id FROM affiliates WHERE affiliate_id = ?) AND deleted_at IS NULL");
        $stmt->bind_param("is", $bank_account_id, $aff_code);
        $stmt->execute();
        if ($stmt->get_result()->num_rows === 0) {
            $response->json(['error' => 'Bank account not found or unauthorized'], 403);
        }
        $stmt->close();

        $stmt = $conn->prepare("
            INSERT INTO affiliate_withdrawals 
            (affiliate_id, bank_account_id, amount, transaction_currency, additional_notes, recorded_by_user_id, recorded_by_role_type) 
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        $recorded_by_role_type = 'Patient';
        $stmt->bind_param("sidssis", $affiliate_id, $bank_account_id, $amount, $transaction_currency, $additional_notes, $user_id, $recorded_by_role_type);

        if ($stmt->execute()) {
            $new_id = $stmt->insert_id;

            $ledger_stmt = $conn->prepare("
                INSERT INTO affiliate_ledger 
                (affiliate_id, withdrawal_id, transaction_type, amount, currency, description, status, created_by) 
                VALUES (?, ?, 'debit', ?, ?, 'Withdrawal request', 'pending', ?)
            ");
            $ledger_stmt->bind_param("sidsi", $affiliate_id, $new_id, $amount, $transaction_currency, $user_id);
            $ledger_stmt->execute();
            $ledger_stmt->close();

            $conn_api = getConnAPI();
            if ($conn_api) {
                $action = 'Affiliate withdrawal requested';
                $resource_type = 'affiliate_withdrawal';
                $details = json_encode(['affiliate_id' => $aff_code, 'amount' => $amount, 'currency' => $transaction_currency]);
                $region_code = null;
                $stmt_api = $conn_api->prepare("
                    INSERT INTO audit_logs (user_id, action, audited_resource_type, audited_resource_id, details, ip_address, created_at, region_code) 
                    VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)
                ");
                $stmt_api->bind_param("ississs", $user_id, $action, $resource_type, $new_id, $details, $ip, $region_code);
                $stmt_api->execute();
                $stmt_api->close();
            }

            $response->json(['withdrawal_id' => $new_id, 'message' => 'Withdrawal requested successfully']);
        } else {
            logError('Failed to insert withdrawal: ' . $stmt->error, 'Database', __FILE__, __LINE__);
            $response->json(['error' => 'Failed to request withdrawal'], 500);
        }
        $stmt->close();
        break;

    case 'GET':
        $stmt = $conn->prepare("SELECT * FROM affiliate_withdrawals WHERE affiliate_id = ? AND deleted_at IS NULL");
        $stmt->bind_param("s", $affiliate_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $withdrawals = [];
        while ($row = $result->fetch_assoc()) {
            $withdrawals[] = $row;
        }
        $response->json($withdrawals);
        $stmt->close();
        break;

    default:
        $response->json(['error' => 'Method not allowed'], 405);
}
?>