<?php
// File name: jwt.php
// File location: /home/apimedi1/public_html/api/v1/middleware/jwt.php

// ------------------------------------------------------------------
// Token validation (device token OR normal JWT)
// ------------------------------------------------------------------
function validateDeviceOrNormalToken($token) {
    $connAPI = getConnAPI();
    // 1. Try long-lived device token first
    $stmt = $connAPI->prepare("
        SELECT udt.user_id, udt.role_type, udt.partner_id
        FROM user_device_tokens udt
        WHERE udt.token = ? AND udt.is_revoked = 0 AND (udt.deleted_at IS NULL)
    ");
    if ($stmt) {
        $stmt->bind_param("s", $token);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            // Update usage
            $upd = $connAPI->prepare("UPDATE user_device_tokens SET last_used_at = NOW(), login_count = login_count + 1 WHERE token = ?");
            if ($upd) {
                $upd->bind_param("s", $token);
                $upd->execute();
            }
            // Live region lookup
            $mainConn = getConnMain();
            $reg = $mainConn->prepare("SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = ? LIMIT 1");
            $region = 'NA';
            if ($reg) {
                $reg->bind_param("i", $row['user_id']);
                $reg->execute();
                $regionRow = $reg->get_result()->fetch_assoc();
                $region = $regionRow['datacenter_region_code'] ?? 'NA';
            }
            return [
                'userId' => (int)$row['user_id'],
                'regionCode' => $region,
                'roleType' => $row['role_type'],
                'partnerId' => $row['partner_id'] ? (int)$row['partner_id'] : null,
                'exp' => time() + (10*365*24*3600),
                'deviceToken' => true
            ];
        }
    }
    // 2. Normal short-lived JWT
    $payload = validateJWT($token);
    if ($payload) {
        return $payload;
    }
    return false;
}

function requireJWT() {
    $header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
    if (!preg_match('/Bearer\s+(\S+)/', $header, $matches)) {
        (new Response)->json(['error' => 'Missing token'], 401);
    }
    $payload = validateDeviceOrNormalToken($matches[1]);
    if (!$payload) {
        (new Response)->json(['error' => 'Invalid token'], 401);
    }
    $GLOBALS['auth_user_id'] = $payload['userId'];
    return $payload['userId'];
}
?>