<?php
// File name: index.php
// File location: /home/apimedi1/public_html/api/v1/index.php
header('X-ModSecurity-Bypass: 1');
header('X-LiteSpeed-Bypass: 1');
header('X-HealthCheck: true');
if (strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'curl') !== false ||
    strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Postman') !== false ||
    strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Insomnia') !== false) {
    header('X-Allowed-Client: API-Tool');
}
require_once __DIR__ . '/../../../secure/config_v2.php';
require_once __DIR__ . '/../../../secure/database_router_v2.php';
require_once __DIR__ . '/middleware/rate_limiter.php';
// RATE LIMIT = 10 FOR TESTING (change to 5000 for production)
rateLimit(10);
// UNIQUE REQUEST_ID
if (!defined('REQUEST_ID')) {
    define('REQUEST_ID', uniqid('req_', true));
}
// LOG REQUEST BEFORE ROUTING
$conn = getConnAPI();
$method = $_SERVER['REQUEST_METHOD'];
$endpoint = $_SERVER['REQUEST_URI'];
$headers = json_encode(getallheaders());
$body_summary = substr(file_get_contents('php://input'), 0, 255);
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$user_id = $GLOBALS['auth_user_id'] ?? null;
$req_id = REQUEST_ID;
$stmt = $conn->prepare("INSERT INTO api_requests (request_id, method, endpoint, headers, body_summary, ip_address, user_id) VALUES (?, ?, ?, ?, ?, ?, ?)");
if ($stmt) {
    $types = "ssssss";
    $params = [$req_id, $method, $endpoint, $headers, $body_summary, $ip];
    if ($user_id !== null) {
        $types .= "i";
        $params[] = (int)$user_id;
    } else {
        $types .= "s";
        $null_value = null;
        $params[] = $null_value;
    }
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $stmt->close();
}
require_once __DIR__ . '/bootstrap/init.php';
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = trim(str_replace('/api/v1', '', $uri), '/');
$uri_parts = $uri ? explode('/', $uri) : [];
$response = new Response();
$route = implode('/', array_slice($uri_parts, 0, 4));
switch ($route) {
    case 'auth/login':
        require __DIR__ . '/routes/auth.php';
        break;
    case 'auth/logout':
        require __DIR__ . '/routes/auth/logout.php';
        break;
    // NEW: User registration endpoint (POST /auth/register)
    case 'auth/register':
        require __DIR__ . '/routes/auth/register.php';
        break;
    case 'api-keys':
    case 'api-keys/':
        require __DIR__ . '/routes/api-keys.php';
        break;
    case 'billing/subscriptions':
        require __DIR__ . '/routes/billing/subscriptions.php';
        break;
    case 'billing/invoices':
        require __DIR__ . '/routes/billing/invoices.php';
        break;
    case 'billing/payments':
        require __DIR__ . '/routes/billing/payments.php';
        break;
    case 'billing/orders':
        require __DIR__ . '/routes/billing/orders.php';
        break;
    case 'billing/disputes':
        require __DIR__ . '/routes/billing/disputes.php';
        break;
    case 'medical/devices/data':
        require __DIR__ . '/routes/medical/devices.php';
        break;
    case 'medical/patients':
        require __DIR__ . '/routes/medical/patients.php';
        break;
    case 'medical/allergies':
        require __DIR__ . '/routes/medical/allergies.php';
        break;
    case 'medical/diagnoses':
        require __DIR__ . '/routes/medical/diagnoses.php';
        break;
    case 'medical/vaccinations':
        require __DIR__ . '/routes/medical/vaccinations.php';
        break;
    case 'medical/vitals':
        require __DIR__ . '/routes/medical/vitals.php';
        break;
    case 'medical/anaesthesia':
        require __DIR__ . '/routes/medical/anaesthesia.php';
        break;
    case 'medical/procedures':
        require __DIR__ . '/routes/medical/procedures.php';
        break;
    case 'medical/anthropometry':
        require __DIR__ . '/routes/medical/anthropometry.php';
        break;
    case 'medical/birth_history':
        require __DIR__ . '/routes/medical/birth_history.php';
        break;
    case 'medical/consultations':
        require __DIR__ . '/routes/medical/consultations.php';
        break;
    case 'medical/emergency_contacts':
        require __DIR__ . '/routes/medical/emergency_contacts.php';
        break;
    case 'medical/apple_health':
        require __DIR__ . '/routes/medical/apple_health.php';
        break;
    case 'medical/cardiovascular_examinations':
        require __DIR__ . '/routes/medical/cardiovascular_examinations.php';
        break;
    case 'medical/cervical_screening':
        require __DIR__ . '/routes/medical/cervical_screening.php';
        break;
    case 'medical/sti_history':
        require __DIR__ . '/routes/medical/sti_history.php';
        break;
    case 'medical/self_assessments':
        require __DIR__ . '/routes/medical/self_assessments.php';
        break;
    
    case 'medical/communication_sessions':
        require __DIR__ . '/routes/medical/communication_sessions.php';
        break;
    case 'medical/haematology_history':
        require __DIR__ . '/routes/medical/haematology_history.php';
        break;
    case 'medical/health_insurance':
        require __DIR__ . '/routes/medical/health_insurance.php';
        break;
    case 'medical/hpv_status':
        require __DIR__ . '/routes/medical/hpv_status.php';
        break;
    case 'medical/family_history':
        require __DIR__ . '/routes/medical/family_history.php';
        break;
    case 'medical/social_history':
        require __DIR__ . '/routes/medical/social_history.php';
        break;
    case 'medical/surgical_history':
        require __DIR__ . '/routes/medical/surgical_history.php';
        break;
    case 'medical/travel_history':
        require __DIR__ . '/routes/medical/travel_history.php';
        break;
    case 'medical/urological_history':
        require __DIR__ . '/routes/medical/urological_history.php';
        break;
    case 'medical/genetic_history':
        require __DIR__ . '/routes/medical/genetic_history.php';
        break;
    
    
    case 'logs/audit':
        require __DIR__ . '/routes/logs/audit.php';
        break;
    case 'logs/errors':
        require __DIR__ . '/routes/logs/errors.php';
        break;
    case 'logs/api-responses':
        require __DIR__ . '/routes/logs/responses.php';
        break;
    case 'health':
    case '':
        require __DIR__ . '/routes/health.php';
        break;
    
    
// NEW: Personal Device Tokens (long-lived tokens for phones/wearables)
    case 'device-tokens':
    case 'device-tokens/':
        require __DIR__ . '/routes/device-tokens.php';
        break;
    
    case 'affiliates':
        require __DIR__ . '/routes/affiliate/affiliates.php';
        break;
    case 'lab/tests':
        require __DIR__ . '/routes/lab/tests.php';
        break;
    case 'lab/orders':
        require __DIR__ . '/routes/lab/orders.php';
        break;
    case 'lab/results':
        require __DIR__ . '/routes/lab/results.php';
        break;
    
    
    case 'panic/vehicles':
        require __DIR__ . '/routes/panic/vehicles.php';
        break;
    case 'panic/locations':
        require __DIR__ . '/routes/panic/locations.php';
        break;
    case 'panic/settings':
        require __DIR__ . '/routes/panic/settings.php';
        break;
    
    
    
    
    // Add this case to the switch statement for the list endpoint
    case 'medical/qr_codes':
        require __DIR__ . '/routes/medical/qr_codes.php';
        break;
    case 'rewards':
        require __DIR__ . '/routes/rewards/rewards.php';
        break;
    case 'rewards/challenges':
        require __DIR__ . '/routes/rewards/challenges.php';
        break;
    case 'rewards/items':
        require __DIR__ . '/routes/rewards/items.php';
        break;
    case 'rewards/redemptions':
        require __DIR__ . '/routes/rewards/redemptions.php';
        break;
    case 'rewards/transactions':
        require __DIR__ . '/routes/rewards/transactions.php';
        break;
    case 'rewards/milestones':
        require __DIR__ . '/routes/rewards/milestones.php';
        break;
    // NEW: Profile creation endpoints (POST /profiles/patient, /profiles/provider, /profiles/partner)
    case 'profiles/patient':
    case 'profiles/provider':
    case 'profiles/partner':
        require __DIR__ . '/routes/profiles.php';
        break;
    // NEW: Profile management endpoints (from previous)
    case 'profile':
    case 'profile/':
        require __DIR__ . '/routes/profile.php';
        break;
    case 'profile/picture':
        require __DIR__ . '/routes/profile.php';
        break;
    case 'profile/identifications':
    case 'profile/identifications/':
        require __DIR__ . '/routes/profile.php';
        break;
    default:
        if (preg_match('#^api-keys/(\d+)$#', $uri, $m) && $_SERVER['REQUEST_METHOD'] === 'DELETE') {
            $_GET['key_id'] = $m[1];
            require __DIR__ . '/routes/api-keys.php';
            break;
        }
    
if (preg_match('#^medical/(allergies|diagnoses|vaccinations|vitals|anaesthesia|anthropometry|birth_history|consultations|emergency_contacts|apple_health|cardiovascular_examinations|cervical_screening|sti_history|self_assessments|communication_sessions|haematology_history|health_insurance|hpv_status|family_history|social_history|surgical_history|travel_history|urological_history|genetic_history|qr_code)/(\d+)$#', $uri, $m)) {
    $_GET['patient_id'] = $m[2];
    require __DIR__ . '/routes/medical/' . $m[1] . '.php';
    break;
}
    
        // Wallet endpoints with account_number (e.g., /wallet/balance/MW-1)
if (preg_match('#^wallet/(balance|transactions|add-funds|withdraw|statements)/([\w-]+)$#', $uri, $m)) {
    $_GET['account_number'] = $m[2];
    $action = $m[1];
    require __DIR__ . "/routes/wallet/{$action}.php";
    break;
}
        if (preg_match('#^affiliates/([\w-]+)$#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/affiliates.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/bank-accounts$#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/bank-accounts.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/bank-accounts/(\d+)$#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            $_GET['bank_id'] = $m[2];
            require __DIR__ . '/routes/affiliate/bank-accounts.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/withdrawals$#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/withdrawals.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/referrals$#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/referrals.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/transactions$#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/transactions.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/balance#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/balance.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/statements#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/statements.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/statements#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/statements.php';
            break;
        }
        if (preg_match('#^affiliates/([\w-]+)/referral-link#', $uri, $m)) {
            $_GET['affiliate_id'] = $m[1];
            require __DIR__ . '/routes/affiliate/referral-link.php';
            break;
        }
    
        // New preg_match for EMI endpoints
        if (preg_match('#^emi/(profile|haematology|allergies|diagnoses|facility-admissions|sti-history|travel-history|emergency-contacts|vaccinations|health-insurance|full)/(\d+)$#', $uri, $m)) {
            $_GET['patient_id'] = $m[2];
            require __DIR__ . '/routes/emi/' . $m[1] . '.php';
            break;
        }
    
    
    
    // Panic Button Preg matches
        if (preg_match('#^panic/events$#', $uri)) {
            require __DIR__ . '/routes/panic/events.php';
            break;
        }
        if (preg_match('#^panic/events/(\d+)$#', $uri, $m)) {
            $_GET['id'] = $m[1];
            require __DIR__ . '/routes/panic/events.php';
            break;
        }
        // Panic event updates
        if (preg_match('#^panic/events/(\d+)/updates$#', $uri, $m)) {
            $_GET['id'] = $m[1];
            require __DIR__ . '/routes/panic/updates.php';
            break;
        }
        // Panic event responders
        if (preg_match('#^panic/events/(\d+)/responders$#', $uri, $m)) {
            $_GET['id'] = $m[1];
            require __DIR__ . '/routes/panic/responders.php';
            break;
        }
    
        // Support DELETE /device-tokens/{id} OR /device-tokens/6
        if (preg_match('#^device-tokens/?(\d*)$#', $uri, $m) && $_SERVER['REQUEST_METHOD'] === 'DELETE') {
            if (!empty($m[1])) {
                $_GET['device_id'] = (int)$m[1];
            }
            require __DIR__ . '/routes/device-tokens.php';
            break;
        }
    
     
        if (preg_match('#^medical/qr_code/(\d+)$#', $uri, $m) && $_SERVER['REQUEST_METHOD'] === 'DELETE') {
            $_GET['qr_code_id'] = $m[1];
            require __DIR__ . '/routes/medical/qr_code.php';
            break;
        }
    
        // For billing/subscriptions/{id} (PUT/DELETE)
        if (preg_match('#^billing/subscriptions/(\d+)$#', $uri, $m)) {
            $_GET['subscription_id'] = (int)$m[1];
            require __DIR__ . '/routes/billing/subscriptions.php';
            break;
        }
        // For billing/invoices/{id} (GET specific)
        if (preg_match('#^billing/invoices/(\d+)$#', $uri, $m)) {
            $_GET['invoice_id'] = (int)$m[1];
            require __DIR__ . '/routes/billing/invoices.php';
            break;
        }
    
    
        // Add similar preg_match for other sub-endpoints as needed
        if (preg_match('#^rewards/challenges/(\d+)$#', $uri, $m)) {
            $_GET['challenge_id'] = (int)$m[1];
            require __DIR__ . '/routes/rewards/challenges.php';
            break;
        }
        if (preg_match('#^rewards/challenges/(\d+)/progress$#', $uri, $m)) {
            $_GET['challenge_id'] = (int)$m[1];
            require __DIR__ . '/routes/rewards/challenges.php';
            break;
        }
        if (preg_match('#^rewards/inventory/(\d+)$#', $uri, $m)) {
            $_GET['item_id'] = (int)$m[1];
            require __DIR__ . '/routes/rewards/inventory.php';
            break;
        }
        if (preg_match('#^rewards/milestones/(\d+)$#', $uri, $m)) {
            $_GET['milestone_id'] = (int)$m[1];
            require __DIR__ . '/routes/rewards/milestones.php';
            break;
        }
        $response->json(['error' => 'Route not found', 'path' => $uri], 404);
}
?>