<?php
// File name: rate_limiter.php
// File location: /home/apimedi1/public_html/api/v1/middleware/rate_limiter.php
// FINAL VERSION — NO ERRORS — WORKS IN apimedi1_meditag_api

// LOAD Response CLASS FIRST (fixes "Class not found")
require_once __DIR__ . '/../handlers/Response.php';
require_once __DIR__ . '/../handlers/logApiResponse.php';

function rateLimit($limit = 1) {
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $conn = getConnAPI();  // YOUR ONLY DB
    if (!$conn) return;

    $now = time();
    $window = 60;

    $stmt = $conn->prepare("SELECT requests, window_start FROM rate_limits WHERE ip = ?");
    $requests = 0;
    $window_start = $now;

    if ($stmt) {
        $stmt->bind_param("s", $ip);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            $requests = (int)$row['requests'];
            $window_start = (int)$row['window_start'];
        }
        $stmt->close();
    }

    if ($now - $window_start >= $window) {
        $requests = 0;
        $window_start = $now;
    }

    $requests++;

    $stmt = $conn->prepare("INSERT INTO rate_limits (ip, requests, window_start) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE requests = ?, window_start = ?");
    if ($stmt) {
        $stmt->bind_param("siiii", $ip, $requests, $window_start, $requests, $window_start);
        $stmt->execute();
        $stmt->close();
    }

    if ($requests > $limit) {
        http_response_code(429);
        header('Retry-After: 60');
        (new Response)->json([
            'error' => 'Rate limit exceeded',
            'message' => "Only $limit request(s) per minute allowed",
            'ip' => $ip,
            'requests' => $requests,
            'retry_in_seconds' => 60 - ($now - $window_start)
        ], 429);
    }
}
?>