<?php
function requireAPIKey() {
    $key = $_SERVER['HTTP_X_API_KEY'] ?? '';
    if (empty($key)) {
        (new Response)->json(['error' => 'API key required'], 401);
    }
    $conn = getConnMain();
    $stmt = $conn->prepare("SELECT id FROM api_keys WHERE api_key = ? AND status = 1");
    $stmt->bind_param("s", $key);
    $stmt->execute();
    if ($stmt->get_result()->num_rows === 0) {
        (new Response)->json(['error' => 'Invalid API key'], 401);
    }
    return $key;
}