<?php
// File: allergies.php
// File Location: /home/apimedi1/public_html/api/v1/routes/medical/allergies.php
$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("SELECT id, allergen_name, reaction_type FROM allergy_history WHERE patient_id = ?");
$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$allergies = [];
while ($row = $result->fetch_assoc()) $allergies[] = $row;

(new Response)->json($allergies);