<?php
// File name: health.php
// File location: /home/apimedi1/public_html/api/v1/routes/health.php

$status = [
    'status' => 'healthy',
    'timestamp' => date('Y-m-d H:i:s'),
    'api_version' => 'v1',
    'server' => $_SERVER['SERVER_NAME'] ?? 'api.meditag.net',
    'php_version' => PHP_VERSION,
    'uptime' => round(microtime(true) - $_SERVER['REQUEST_TIME_FLOAT'], 3) . 's',
    'databases' => []
];

// Global connections
$status['databases']['global_core'] = getConnMain() ? 'ONLINE' : 'OFFLINE';
$status['databases']['billing'] = getConnBilling() ? 'ONLINE' : 'OFFLINE';
$status['databases']['api'] = getConnAPI() ? 'ONLINE' : 'OFFLINE';
$status['databases']['wallet'] = getConnWallet() ? 'ONLINE' : 'OFFLINE';
$status['databases']['file_manager'] = getConnFileManager() ? 'ONLINE' : 'OFFLINE';
$status['databases']['lab_tests'] = getConnLabTests() ? 'ONLINE' : 'OFFLINE';
$status['databases']['imaging'] = getConnImaging() ? 'ONLINE' : 'OFFLINE';
$status['databases']['prescriptions'] = getConnPrescriptions() ? 'ONLINE' : 'OFFLINE';
$status['databases']['medications'] = getConnMedications() ? 'ONLINE' : 'OFFLINE';
$status['databases']['sideroom_investigations'] = getConnSideroomInvestigations() ? 'ONLINE' : 'OFFLINE';
$status['databases']['audit'] = getConnAudit() ? 'ONLINE' : 'OFFLINE';
$status['databases']['affiliates'] = getConnAffiliates() ? 'ONLINE' : 'OFFLINE';
$status['databases']['rewards'] = getConnRewards() ? 'ONLINE' : 'OFFLINE';
$status['databases']['messaging'] = getConnMessaging() ? 'ONLINE' : 'OFFLINE';
$status['databases']['panic_service'] = getConnPanicService() ? 'ONLINE' : 'OFFLINE';
$status['databases']['accounting'] = getConnAccounting() ? 'ONLINE' : 'OFFLINE';
$status['databases']['app_store'] = getConnAppStore() ? 'ONLINE' : 'OFFLINE';
$status['databases']['appointments'] = getConnAppointments() ? 'ONLINE' : 'OFFLINE';
$status['databases']['call_centre'] = getConnCallCentre() ? 'ONLINE' : 'OFFLINE';
$status['databases']['manager'] = getConnManager() ? 'ONLINE' : 'OFFLINE';

// Regional connections for NA
$status['databases']['main_na'] = getConnMainNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['medical_data_na'] = getConnMedicalDataNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['file_manager_na'] = getConnFileManagerNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['wallet_na'] = getConnWalletNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['partner_billing_na'] = getConnPartnerBillingNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['lab_tests_na'] = getConnLabTestsNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['imaging_na'] = getConnImagingNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['prescriptions_na'] = getConnPrescriptionsNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['medications_na'] = getConnMedicationsNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['sideroom_investigations_na'] = getConnSideroomInvestigationsNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['audit_na'] = getConnAuditNA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['appointments_na'] = getConnAppointmentsNA() ? 'ONLINE' : 'OFFLINE';

// Regional connections for ZA
$status['databases']['main_za'] = getConnMainZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['medical_data_za'] = getConnMedicalDataZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['file_manager_za'] = getConnFileManagerZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['wallet_za'] = getConnWalletZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['partner_billing_za'] = getConnPartnerBillingZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['lab_tests_za'] = getConnLabTestsZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['imaging_za'] = getConnImagingZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['prescriptions_za'] = getConnPrescriptionsZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['medications_za'] = getConnMedicationsZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['sideroom_investigations_za'] = getConnSideroomInvestigationsZA() ? 'ONLINE' : 'OFFLINE';
$status['databases']['audit_za'] = getConnAuditZA() ? 'ONLINE' : 'OFFLINE';

// Regional connections for US
$status['databases']['main_us'] = getConnMainUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['medical_data_us'] = getConnMedicalDataUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['file_manager_us'] = getConnFileManagerUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['wallet_us'] = getConnWalletUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['partner_billing_us'] = getConnPartnerBillingUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['lab_tests_us'] = getConnLabTestsUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['imaging_us'] = getConnImagingUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['prescriptions_us'] = getConnPrescriptionsUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['medications_us'] = getConnMedicationsUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['sideroom_investigations_us'] = getConnSideroomInvestigationsUS() ? 'ONLINE' : 'OFFLINE';
$status['databases']['audit_us'] = getConnAuditUS() ? 'ONLINE' : 'OFFLINE';

// Check overall status
$all_online = true;
foreach ($status['databases'] as $db_status) {
    if ($db_status !== 'ONLINE') {
        $all_online = false;
        $status['status'] = 'partial outage';
    }
}
if (!$all_online) {
    $status['status'] = 'degraded';
}

(new Response)->json($status);
?>