<?php
// File name: api-keys.php
// File location: /home/apimedi1/public_html/api/v1/routes/api-keys.php

require_once __DIR__ . '/../middleware/jwt.php';  // Load JWT middleware (defines requireJWT())

$method = $_SERVER['REQUEST_METHOD'];
$userId = requireJWT();  // Enforces JWT auth

if ($method === 'POST') {
    $data = getJsonInput();
    $description = $data['description'] ?? '';

    if (empty($description)) {
        $response->json(['error' => 'Description required'], 400);
    }

    $api_key = bin2hex(random_bytes(32));  // Secure 64-char hex key

    $conn = getConnAPI();
    $stmt = $conn->prepare("INSERT INTO api_keys (api_key, description, status, created_by, assigned_to, created_at, updated_at) VALUES (?, ?, 1, ?, ?, NOW(), NOW())");
    if ($stmt) {
        $stmt->bind_param("ssii", $api_key, $description, $userId, $userId);
        $stmt->execute();
        $id = $stmt->insert_id;
        $stmt->close();

        $response->json([
            'id' => $id,
            'api_key' => $api_key,
            'description' => $description,
            'status' => 1
        ], 201);
    } else {
        $response->json(['error' => 'Failed to create API key'], 500);
    }
} elseif ($method === 'DELETE') {
    $keyId = (int)($_GET['key_id'] ?? 0);
    if ($keyId <= 0) {
        $response->json(['error' => 'Invalid key ID'], 400);
    }

    $conn = getConnAPI();
    $checkStmt = $conn->prepare("SELECT id FROM api_keys WHERE id = ? AND (created_by = ? OR assigned_to = ?)");
    if ($checkStmt) {
        $checkStmt->bind_param("iii", $keyId, $userId, $userId);
        $checkStmt->execute();
        $result = $checkStmt->get_result();
        if ($result->num_rows === 0) {
            $response->json(['error' => 'Forbidden or key not found'], 403);
        }
        $checkStmt->close();
    }

    $stmt = $conn->prepare("UPDATE api_keys SET status = 0 WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $keyId);
        $stmt->execute();
        $stmt->close();
        http_response_code(204);
        exit;
    } else {
        $response->json(['error' => 'Failed to revoke key'], 500);
    }
} else {
    $response->json(['error' => 'Method Not Allowed'], 405);
}
?> 

After uploading, test in Postman:
- **Method**: POST
- **URL**: https://api.meditag.net/api/v1/api-keys
- **Headers**:
  - Authorization: Bearer [your JWT token from /auth/login]
- **Body > raw > JSON**:
  ```json
  {
    "description": "Test Developer Key"
  }