<?php
// File name: region.php
// File location: /home/apimedi1/public_html/api/v1/utils/region.php

function getPatientRegion($patientId) {
    $conn = getConnMain();
    
    // Check if connection is valid
    if (!$conn || $conn->connect_error) {
        logError("Failed to connect to main database: " . ($conn ? $conn->connect_error : 'No connection'), 'Database', __FILE__, __LINE__);
        return 'NA'; // Fallback to default region on error
    }
    
    // Ping to ensure connection is alive, with suppression to avoid warning
    if (!@$conn->ping()) {
        logError("Database connection lost in getPatientRegion", 'Database', __FILE__, __LINE__);
        return 'NA'; // Fallback
    }
    
    $stmt = $conn->prepare("SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1");
    
    if (!$stmt) {
        logError("Prepare failed in getPatientRegion: " . $conn->error, 'Database', __FILE__, __LINE__);
        return 'NA'; // Graceful failure
    }
    
    $stmt->bind_param("i", $patientId);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close(); // Always close statement
    
    return $row['datacenter_region_code'] ?? 'NA';
}