<?php
// File name: transactions.php
// File location: /home/apimedi1/public_html/api/v1/routes/wallet/transactions.php

require_once __DIR__ . '/../../middleware/jwt.php';
$userId = requireJWT();

$account_number = $_GET['account_number'] ?? '';
if (empty($account_number)) {
    (new Response)->json(['error' => 'Invalid account number'], 400);
}

$region = getPatientRegion($userId);
$conn_regional = getDatabaseConnection('wallet', $region);
$conn_global = getConnWallet();
$conn_main = getConnMain();

// Verify wallet + ownership
$stmt = $conn_global->prepare("SELECT patient_id, provider_id, partner_id FROM wallets WHERE account_number = ? LIMIT 1");
$stmt->bind_param("s", $account_number);
$stmt->execute();
$wallet = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$wallet) {
    (new Response)->json(['error' => 'Wallet not found'], 404);
}

if ($wallet['patient_id']) {
    $type = 'patient'; $entity_id = $wallet['patient_id'];
} elseif ($wallet['provider_id']) {
    $type = 'provider'; $entity_id = $wallet['provider_id'];
} elseif ($wallet['partner_id']) {
    $type = 'partner'; $entity_id = $wallet['partner_id'];
} else {
    (new Response)->json(['error' => 'Invalid wallet linkage'], 500);
}

$stmt_owner = $conn_main->prepare("SELECT user_id FROM {$type}s WHERE id = ? LIMIT 1");
$stmt_owner->bind_param("i", $entity_id);
$stmt_owner->execute();
$owner = $stmt_owner->get_result()->fetch_assoc();
$stmt_owner->close();

if (!$owner || $owner['user_id'] != $userId) {
    (new Response)->json(['error' => 'Unauthorized access to wallet'], 403);
}

// Verify regional account exists
$stmt_check = $conn_regional->prepare("SELECT 1 FROM user_bank_accounts WHERE account_number = ? LIMIT 1");
$stmt_check->bind_param("s", $account_number);
$stmt_check->execute();
if ($stmt_check->get_result()->num_rows === 0) {
    (new Response)->json(['error' => 'Regional account not found'], 404);
}
$stmt_check->close();

// Fetch transactions
$stmt = $conn_regional->prepare("
    SELECT id, transaction_type, transaction_category, amount, currency, 
           transaction_date, description, status 
    FROM transactions 
    WHERE account_number = ? 
    ORDER BY transaction_date DESC 
    LIMIT 50
");
$stmt->bind_param("s", $account_number);
$stmt->execute();
$result = $stmt->get_result();

$transactions = [];
while ($row = $result->fetch_assoc()) {
    $row['transaction_date'] = date('Y-m-d H:i:s', strtotime($row['transaction_date']));
    $transactions[] = $row;
}
$stmt->close();

(new Response)->json([
    'type' => $type,
    'account_number' => $account_number,
    'region' => $region,
    'totalTransactions' => count($transactions),
    'transactions' => $transactions,
    'retrievedAt' => date('c')
]);
?>