<?php
// File name: add-funds.php
// File location: /home/apimedi1/public_html/api/v1/routes/wallet/add-funds.php

require_once __DIR__ . '/../../middleware/jwt.php';
$userId = requireJWT();

$account_number = $_GET['account_number'] ?? '';
if (empty($account_number)) {
    (new Response)->json(['error' => 'Invalid account number'], 400);
}

$data = getJsonInput();
$amount = (float)($data['amount'] ?? 0);
$currency = $data['currency'] ?? 'NAD';
$description = $data['description'] ?? 'Funds added via API';

if ($amount <= 0) {
    (new Response)->json(['error' => 'Amount must be greater than 0'], 400);
}

$region = getPatientRegion($userId);
$conn_regional = getDatabaseConnection('wallet', $region);
$conn_global = getConnWallet();
$conn_main = getConnMain();

// Fetch and validate wallet
$stmt = $conn_global->prepare("SELECT currency, patient_id, provider_id, partner_id FROM wallets WHERE account_number = ? LIMIT 1");
$stmt->bind_param("s", $account_number);
$stmt->execute();
$wallet = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$wallet) {
    (new Response)->json(['error' => 'Wallet not found'], 404);
}
if ($currency !== $wallet['currency']) {
    (new Response)->json(['error' => 'Currency mismatch'], 400);
}

if ($wallet['patient_id']) {
    $type = 'patient'; $entity_id = $wallet['patient_id'];
} elseif ($wallet['provider_id']) {
    $type = 'provider'; $entity_id = $wallet['provider_id'];
} elseif ($wallet['partner_id']) {
    $type = 'partner'; $entity_id = $wallet['partner_id'];
} else {
    (new Response)->json(['error' => 'Invalid wallet linkage'], 500);
}

// Ownership check
$stmt_owner = $conn_main->prepare("SELECT user_id FROM {$type}s WHERE id = ? LIMIT 1");
$stmt_owner->bind_param("i", $entity_id);
$stmt_owner->execute();
$owner = $stmt_owner->get_result()->fetch_assoc();
$stmt_owner->close();

if (!$owner || $owner['user_id'] != $userId) {
    (new Response)->json(['error' => 'Unauthorized access to wallet'], 403);
}

// Update balance
$stmt_global = $conn_global->prepare("UPDATE wallets SET balance = balance + ? WHERE account_number = ?");
$stmt_global->bind_param("ds", $amount, $account_number);
if (!$stmt_global->execute()) {
    logError("Balance update failed: " . $stmt_global->error, 'Wallet', __FILE__, __LINE__);
    (new Response)->json(['error' => 'Failed to update balance'], 500);
}
$stmt_global->close();

// Insert transaction
$payer_type = $payer_id = null;
$payee_type = strtolower($type);
$payee_id = $entity_id;
$role_type = ucfirst($type);

$stmt_tx = $conn_regional->prepare("
    INSERT INTO transactions 
    (account_number, transaction_type, transaction_category, amount, currency,
     payer_type, payer_id, payee_type, payee_id,
     created_by_user_id, created_by_role_type, description, status, created_at)
    VALUES 
    (?, 'Credit', 'Deposit', ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Pending', NOW())
");
$stmt_tx->bind_param(
    "sdsssiisiss",
    $account_number, $amount, $currency,
    $payer_type, $payer_id,
    $payee_type, $payee_id,
    $userId, $role_type, $description
);

if (!$stmt_tx->execute()) {
    logError("Transaction insert failed: " . $stmt_tx->error, 'Wallet', __FILE__, __LINE__);
    $conn_global->query("UPDATE wallets SET balance = balance - $amount WHERE account_number = '$account_number'");
    (new Response)->json(['error' => 'Failed to record transaction'], 500);
}
$stmt_tx->close();

(new Response)->json([
    'type' => $type,
    'account_number' => $account_number,
    'region' => $region,
    'amountAdded' => $amount,
    'currency' => $currency,
    'message' => 'Funds added successfully (pending confirmation)',
    'addedAt' => date('c')
], 201);
?>