<?php
// File name: items.php
// File location: /home/apimedi1/public_html/api/v1/routes/rewards/items.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userPayload = validateJWT($_SERVER['HTTP_AUTHORIZATION'] ?? '');
if (!$userPayload) {
    (new Response)->json(['error' => 'Invalid token'], 401);
}
$region = $userPayload['regionCode'] ?? 'GLOBAL';

$connRewards = getConnRewards();

$stmt = $connRewards->prepare("SELECT rt.*, pi.available_units FROM reward_types rt LEFT JOIN product_inventory pi ON rt.id = pi.reward_type_id WHERE rt.region = ? OR rt.region = 'GLOBAL' AND rt.is_active = 1");
$stmt->bind_param("s", $region);
$stmt->execute();
$result = $stmt->get_result();
$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}
(new Response)->json($items);
?>