<?php
// File name: responders.php
// File location: /home/apimedi1/public_html/api/v1/routes/panic/responders.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../../../../secure/config_v2.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

$response = new Response();
$input = getJsonInput();
$method = $_SERVER['REQUEST_METHOD'];

$conn_panic = getDatabaseConnection('panic_service', 'GBL');
if (!$conn_panic) {
    $response->json(['error' => 'Database connection failed'], 500);
}

if ($method !== 'POST') {
    $response->json(['error' => 'Method not allowed'], 405);
}

requireJWT(); // Admin check can be added

$event_id = (int)$_GET['id'] ?? 0;
if (!$event_id) {
    $response->json(['error' => 'Missing event_id'], 400);
}

$provider_id = (int)$input['provider_id'] ?? 0;
$vehicle_id = isset($input['vehicle_id']) ? (int)$input['vehicle_id'] : null;
$organization_id = isset($input['organization_id']) ? (int)$input['organization_id'] : null;
$facility_id = isset($input['facility_id']) ? (int)$input['facility_id'] : null;

if (!$provider_id) {
    $response->json(['error' => 'Missing provider_id'], 400);
}

$stmt = $conn_panic->prepare("
    INSERT INTO panic_event_responders 
    (event_id, provider_id, assigned_at, organization_id, facility_id, vehicle_id)
    VALUES (?, ?, NOW(), ?, ?, ?)
");
$stmt->bind_param('iiiii', $event_id, $provider_id, $organization_id, $facility_id, $vehicle_id);
if ($stmt->execute()) {
    $responder_id = $stmt->insert_id;
    // Optionally update event status to 'dispatched'
    $conn_panic->query("UPDATE panic_button_events SET status = 'dispatched' WHERE id = $event_id");
    $response->json(['success' => true, 'responder_id' => $responder_id], 201);
} else {
    $response->json(['success' => false, 'message' => $stmt->error], 500);
}
$stmt->close();