<?php
// File name: surgical_history.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/surgical_history.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        procedure_code,
        date,
        procedure_name,
        procedure_outcome,
        surgeon,
        facility,
        reason,
        complications,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM surgical_history 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY date DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$surgical_history = [];
while ($row = $result->fetch_assoc()) {
    $row['date'] = $row['date'] ? date('Y-m-d', strtotime($row['date'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $surgical_history[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($surgical_history),
    'surgicalHistory' => $surgical_history,
    'retrievedAt' => date('c')
]);
?>