<?php
// File name: health_insurance.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/health_insurance.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        medical_aid_name,
        medical_aid_number,
        medical_aid_plan,
        dependant_code,
        main_member,
        start_date,
        end_date,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM health_insurance_history 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY start_date DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$insurance = [];
while ($row = $result->fetch_assoc()) {
    $row['start_date'] = $row['start_date'] ? date('Y-m-d', strtotime($row['start_date'])) : null;
    $row['end_date'] = $row['end_date'] ? date('Y-m-d', strtotime($row['end_date'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $insurance[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($insurance),
    'healthInsuranceHistory' => $insurance,
    'retrievedAt' => date('c')
]);
?>