<?php
// File name: consultations.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/consultations.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        type,
        tenant_id,
        organization_id,
        facility_id,
        partner_id,
        provider_id,
        consultation_datetime,
        consultation_summary,
        flagged_as_error,
        error_notes,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason,
        consultation_session_id
    FROM consultations 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY consultation_datetime DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$consultations = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['consultation_datetime'] = $row['consultation_datetime'] ? date('Y-m-d H:i:s', strtotime($row['consultation_datetime'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $consultations[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalConsultations' => count($consultations),
    'consultations' => $consultations,
    'retrievedAt' => date('c')
]);
?>