<?php
// File name: cardiovascular_examinations.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/cardiovascular_examinations.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        consultation_id,
        chest_shape,
        chest_shape_other,
        visible_pulsations_location,
        visible_pulsations_characteristics,
        skin_changes_present,
        chest_expansion,
        pmi,
        heaves_location,
        heaves_characteristics,
        thrills_location,
        thrills_characteristics,
        water_hammer_pulse_present,
        water_hammer_pulse_description,
        heart_sound_S1_present,
        heart_sound_S1_quality,
        heart_sound_S1_description,
        heart_sound_S2_present,
        heart_sound_S2_quality,
        heart_sound_S2_description,
        heart_sound_S3_present,
        heart_sound_S3_quality,
        heart_sound_S3_description,
        heart_sound_S4_present,
        heart_sound_S4_quality,
        heart_sound_S4_description,
        murmurs_present,
        murmurs_description,
        murmurs_sound_wave,
        radial_pulse_present,
        radial_pulse_rate,
        radial_pulse_quality,
        radial_pulse_quality_other,
        carotid_pulse_present,
        carotid_pulse_rate,
        carotid_pulse_quality,
        carotid_pulse_quality_other,
        femoral_pulse_present,
        femoral_pulse_rate,
        femoral_pulse_quality,
        femoral_pulse_quality_other,
        other_pulses_present,
        other_pulses_type,
        other_pulses_type_other,
        other_pulses_rate,
        other_pulses_quality,
        other_pulses_quality_other,
        peripheral_edema_present,
        peripheral_edema_location,
        peripheral_edema_location_other,
        peripheral_edema_severity,
        peripheral_edema_severity_other,
        jvd_present,
        jvd_height,
        jvd_direction,
        jvd_direction_other,
        capillary_refill_present,
        capillary_refill_time,
        capillary_refill_quality,
        capillary_refill_quality_other,
        additional_finding_hypertension_present,
        hypertension_level,
        hypertension_duration,
        additional_finding_valvular_disease_present,
        valvular_disease_type,
        valvular_disease_type_other,
        valvular_disease_severity,
        implant_present,
        implant_type,
        implant_type_other,
        implant_notes,
        notes,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        flagged_as_error,
        error_notes,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM cardiovascular_examinations 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY recorded_at DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$examinations = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $examinations[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalExaminations' => count($examinations),
    'cardiovascularExaminations' => $examinations,
    'retrievedAt' => date('c')
]);
?>