<?php
// File name: results.php
// File location: /home/apimedi1/public_html/api/v1/routes/lab/results.php
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../utils/region.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        (new Response)->json(['error' => 'Method Not Allowed'], 405);
    }

    requireJWT();

    $patient_id = $_GET['patient_id'] ?? 0;

    if (!$patient_id) {
        (new Response)->json(['error' => 'Patient ID required'], 400);
    }

    $region = getPatientRegion($patient_id);

    $conn = getDatabaseConnection('lab_tests', $region);

    if (!$conn) {
        (new Response)->json(['error' => 'Database connection failed'], 500);
    }

    $stmt = $conn->prepare("
        SELECT 
            ltr.id, ltr.lab_tests_id, ltr.test_value, ltr.requisition_number, ltr.partner_id, ltr.facility_id,
            ltr.requesting_provider_id, ltr.collecting_provider_id, ltr.created_by, ltr.validation_status,
            ltr.validation_method, ltr.validated_by_user_id, ltr.validated_by_role_type, ltr.validated_at,
            ltr.validation_reason, ltr.flagged_as_error, ltr.error_notes, ltr.error_flagged_by_user_id,
            ltr.error_flagged_by_role_type, ltr.error_flagged_at, ltr.system_created_at, ltr.recorded_by_user_id,
            ltr.recorded_by_role_type, ltr.recorded_at, ltr.updated_by_user_id, ltr.updated_by_role_type,
            ltr.updated_at, ltr.update_reason, ltr.deleted_by_user_id, ltr.deleted_by_role_type,
            ltr.deleted_at, ltr.delete_reason, ltr.reference_range, ltr.units_of_measurement_id,
            ltr.critical_values, ltr.interpretation_guidelines, ltr.document_upload, ltr.upload_verification_status,
            ltr.accession_number, ltr.requested_at, ltr.sample_collected_at, ltr.sample_received_at,
            ltr.analysis_completed_at, ltr.result_released_at, ltr.specimen_condition, ltr.sample_rejection_reason,
            ltr.processed_by_user_id, ltr.processed_by_role_type, ltr.processed_at, ltr.instrument_used,
            ltr.instrument_id, ltr.test_order_id,
            lt.test_name, lt.test_code
        FROM lab_test_results ltr
        INNER JOIN lab_tests lt ON ltr.lab_tests_id = lt.id
        WHERE ltr.patient_id = ? AND ltr.is_deleted = 0
        ORDER BY ltr.requested_at DESC
    ");

    if (!$stmt) {
        (new Response)->json(['error' => 'Query preparation failed: ' . $conn->error], 500);
    }

    $stmt->bind_param("i", $patient_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $lab_results = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    // Log views for each result
    $auth_user_id = $GLOBALS['auth_user_id'];
    $viewed_at = date('Y-m-d H:i:s');
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';

    foreach ($lab_results as $res) {
        $view_stmt = $conn->prepare("
            INSERT INTO lab_test_result_views 
            (lab_test_result_id, viewed_by_user_id, viewed_by_role_type, viewed_at, viewed_by_ip)
            VALUES (?, ?, 'Provider', ?, ?)
        ");
        if ($view_stmt) {  // Assuming role_type 'Provider' for now; adjust based on actual role
            $view_stmt->bind_param("iiss", $res['id'], $auth_user_id, $viewed_at, $ip);
            $view_stmt->execute();
            $view_stmt->close();
        }
    }

    (new Response)->json($lab_results);
} elseif ($method === 'POST') {
    requireJWT();

    $data = getJsonInput();
    $patient_id = $data['patient_id'] ?? 0;
    $lab_tests_id = $data['lab_tests_id'] ?? 0;
    $test_value = $data['test_value'] ?? '';
    $requisition_number = $data['requisition_number'] ?? '';
    $partner_id = $data['partner_id'] ?? 0;
    $facility_id = $data['facility_id'] ?? 0;
    $requesting_provider_id = $data['requesting_provider_id'] ?? 0;
    $collecting_provider_id = $data['collecting_provider_id'] ?? null;
    $created_by = $GLOBALS['auth_user_id'];
    $validation_status = $data['validation_status'] ?? 'Pending Validation';
    $validation_method = $data['validation_method'] ?? null;
    $validated_by_user_id = $data['validated_by_user_id'] ?? null;
    $validated_by_role_type = $data['validated_by_role_type'] ?? null;
    $validated_at = $data['validated_at'] ?? null;
    $validation_reason = $data['validation_reason'] ?? null;
    $flagged_as_error = $data['flagged_as_error'] ?? 0;
    $error_notes = $data['error_notes'] ?? null;
    $error_flagged_by_user_id = $data['error_flagged_by_user_id'] ?? null;
    $error_flagged_by_role_type = $data['error_flagged_by_role_type'] ?? null;
    $error_flagged_at = $data['error_flagged_at'] ?? null;
    $recorded_by_user_id = $data['recorded_by_user_id'] ?? null;
    $recorded_by_role_type = $data['recorded_by_role_type'] ?? null;
    $updated_by_user_id = $data['updated_by_user_id'] ?? null;
    $updated_by_role_type = $data['updated_by_role_type'] ?? null;
    $update_reason = $data['update_reason'] ?? null;
    $deleted_by_user_id = $data['deleted_by_user_id'] ?? null;
    $deleted_by_role_type = $data['deleted_by_role_type'] ?? null;
    $deleted_at = $data['deleted_at'] ?? null;
    $delete_reason = $data['delete_reason'] ?? null;
    $reference_range = $data['reference_range'] ?? null;
    $units_of_measurement_id = $data['units_of_measurement_id'] ?? null;
    $critical_values = $data['critical_values'] ?? null;
    $interpretation_guidelines = $data['interpretation_guidelines'] ?? null;
    $document_upload = $data['document_upload'] ?? null;
    $upload_verification_status = $data['upload_verification_status'] ?? 'Pending';
    $accession_number = $data['accession_number'] ?? null;
    $sample_collected_at = $data['sample_collected_at'] ?? null;
    $sample_received_at = $data['sample_received_at'] ?? null;
    $analysis_completed_at = $data['analysis_completed_at'] ?? null;
    $result_released_at = $data['result_released_at'] ?? null;
    $specimen_condition = $data['specimen_condition'] ?? null;
    $sample_rejection_reason = $data['sample_rejection_reason'] ?? null;
    $processed_by_user_id = $data['processed_by_user_id'] ?? null;
    $processed_by_role_type = $data['processed_by_role_type'] ?? null;
    $processed_at = $data['processed_at'] ?? null;
    $instrument_used = $data['instrument_used'] ?? null;
    $instrument_id = $data['instrument_id'] ?? null;
    $test_order_id = $data['test_order_id'] ?? null;

    if (!$patient_id || !$lab_tests_id || !$test_value || !$requisition_number || !$partner_id || !$facility_id || !$requesting_provider_id) {
        (new Response)->json(['error' => 'Required fields missing (patient_id, lab_tests_id, test_value, requisition_number, partner_id, facility_id, requesting_provider_id)'], 400);
    }

    $region = getPatientRegion($patient_id);

    $conn = getDatabaseConnection('lab_tests', $region);

    if (!$conn) {
        (new Response)->json(['error' => 'Database connection failed'], 500);
    }

    $stmt = $conn->prepare("
        INSERT INTO lab_test_results 
        (patient_id, lab_tests_id, test_value, requisition_number, partner_id, facility_id, 
         requesting_provider_id, collecting_provider_id, created_by, validation_status, 
         validation_method, validated_by_user_id, validated_by_role_type, validated_at, 
         validation_reason, flagged_as_error, error_notes, error_flagged_by_user_id, 
         error_flagged_by_role_type, error_flagged_at, recorded_by_user_id, 
         recorded_by_role_type, updated_by_user_id, updated_by_role_type, 
         update_reason, deleted_by_user_id, deleted_by_role_type, deleted_at, 
         delete_reason, reference_range, units_of_measurement_id, critical_values, 
         interpretation_guidelines, document_upload, upload_verification_status, 
         accession_number, sample_collected_at, sample_received_at, 
         analysis_completed_at, result_released_at, specimen_condition, 
         sample_rejection_reason, processed_by_user_id, processed_by_role_type, 
         processed_at, instrument_used, instrument_id, test_order_id)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        (new Response)->json(['error' => 'Query preparation failed: ' . $conn->error], 500);
    }

    $stmt->bind_param("iissiiiiiisssssissssssssssssssssssssssssssssssssssi", 
        $patient_id, $lab_tests_id, $test_value, $requisition_number, $partner_id, $facility_id, 
        $requesting_provider_id, $collecting_provider_id, $created_by, $validation_status, 
        $validation_method, $validated_by_user_id, $validated_by_role_type, $validated_at, 
        $validation_reason, $flagged_as_error, $error_notes, $error_flagged_by_user_id, 
        $error_flagged_by_role_type, $error_flagged_at, $recorded_by_user_id, 
        $recorded_by_role_type, $updated_by_user_id, $updated_by_role_type, 
        $update_reason, $deleted_by_user_id, $deleted_by_role_type, $deleted_at, 
        $delete_reason, $reference_range, $units_of_measurement_id, $critical_values, 
        $interpretation_guidelines, $document_upload, $upload_verification_status, 
        $accession_number, $sample_collected_at, $sample_received_at, 
        $analysis_completed_at, $result_released_at, $specimen_condition, 
        $sample_rejection_reason, $processed_by_user_id, $processed_by_role_type, 
        $processed_at, $instrument_used, $instrument_id, $test_order_id
    );

    if ($stmt->execute()) {
        $result_id = $stmt->insert_id;
        (new Response)->json(['message' => 'Result created', 'result_id' => $result_id], 201);
    } else {
        (new Response)->json(['error' => 'Result creation failed: ' . $stmt->error], 500);
    }
    $stmt->close();
} else {
    (new Response)->json(['error' => 'Method Not Allowed'], 405);
}
?>