<?php
// File name: travel-history.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/travel-history.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_travel_history FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_travel_history'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch travel history
$travels = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND deleted_at IS NULL AND validation_status='Validated'" : " AND deleted_at IS NULL";
$sqlTravel = "SELECT destination_country, start_date, end_date, purpose_of_travel, additional_notes as notes 
              FROM travel_history WHERE patient_id=? $where ORDER BY system_created_at DESC";
$stmT = $connMedicalRegion->prepare($sqlTravel);
$stmT->bind_param('i', $patientId);
$stmT->execute();
$rt = $stmT->get_result();
while ($tr = $rt->fetch_assoc()) {
    $travels[] = $tr;
}
$stmT->close();

(new Response)->json(['travel_history' => $travels], !empty($travels) ? 200 : 404);
?>