<?php
// File name: sti-history.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/sti-history.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_sti_tests FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_sti_tests'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch STI history
$stis = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND sh.deleted_at IS NULL AND sh.validation_status='Validated'" : " AND sh.deleted_at IS NULL";
$sqlSTI = "SELECT sh.id, st.type_name as sti_name, sh.diagnosis_status, sh.diagnosis_date, sh.treatment_status, sh.treatment_details 
           FROM sti_history sh LEFT JOIN sti_types st ON sh.sti_type_id=st.id 
           WHERE sh.patient_id=? $where ORDER BY sh.system_created_at DESC";
$stmS = $connMedicalRegion->prepare($sqlSTI);
$stmS->bind_param('i', $patientId);
$stmS->execute();
$rs = $stmS->get_result();
while ($srow = $rs->fetch_assoc()) {
    $stis[] = $srow;
}
$stmS->close();

(new Response)->json(['sti_history' => $stis], !empty($stis) ? 200 : 404);
?>