<?php
// File name: profile.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/profile.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMainRegion = getDatabaseConnection('main', $regionCode);

if (!$connMainGlobal || !$connMainRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$qrVisibility = [];
$sqlQr = "SELECT visibility_profile_photo, visibility_title, visibility_first_name, visibility_last_name FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

// Check visibility (simplified; adjust as needed)
if (empty($qrRow) || $qrRow['visibility_profile_photo'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch profile
$userProfile = [];
$sqlUser = "SELECT u.title, u.first_name, u.last_name, u.race, u.gender, ua.country, u.date_of_birth 
    FROM users u LEFT JOIN user_addresses ua ON u.id = ua.user_id 
    WHERE u.id = (SELECT user_id FROM patients WHERE id = ?) AND u.deleted_at IS NULL LIMIT 1";
$stmtUser = $connMainRegion->prepare($sqlUser);
$stmtUser->bind_param('i', $patientId);
$stmtUser->execute();
$rU = $stmtUser->get_result();
if ($urow = $rU->fetch_assoc()) {
    $userProfile = $urow;
}
$stmtUser->close();

// Profile photo
$profilePhotoUrl = '';
$sqlProfilePic = "SELECT profile_pic FROM patients WHERE id = ? AND deleted_at IS NULL LIMIT 1";
$stmtProfilePic = $connMainRegion->prepare($sqlProfilePic);
$stmtProfilePic->bind_param('i', $patientId);
$stmtProfilePic->execute();
$result = $stmtProfilePic->get_result();
if ($row = $result->fetch_assoc()) {
    $profilePhotoUrl = $row['profile_pic'] ?: '/images/icons/user-placeholder.png';
}
$stmtProfilePic->close();

// Age calculation
$age = null;
if (!empty($userProfile['date_of_birth'])) {
    $dob = new DateTime($userProfile['date_of_birth']);
    $now = new DateTime();
    $age = $now->diff($dob)->y;
}
$userProfile['age'] = $age;
$userProfile['profile_photo_url'] = $profilePhotoUrl;

(new Response)->json($userProfile, 200);
?>