<?php
// File name: health-insurance.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/health-insurance.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_health_insurance FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_health_insurance'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch health insurance
$healthIns = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND deleted_at IS NULL AND validation_status='Validated'" : " AND deleted_at IS NULL";
$sqlHI = "SELECT medical_aid_name, medical_aid_number, medical_aid_plan, main_member, dependant_code 
          FROM health_insurance_history WHERE patient_id=? $where ORDER BY id DESC LIMIT 1";
$stmHI = $connMedicalRegion->prepare($sqlHI);
$stmHI->bind_param('i', $patientId);
$stmHI->execute();
$rHI = $stmHI->get_result();
if ($hi = $rHI->fetch_assoc()) {
    $healthIns = $hi;
}
$stmHI->close();

(new Response)->json($healthIns ?: ['message' => 'No data found'], $healthIns ? 200 : 404);
?>