<?php
// File name: allergies.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/allergies.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_allergies FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_allergies'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch allergies
$allergies = [];
$epinephrineGlobal = 'No';
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND deleted_at IS NULL AND validation_status='Validated'" : " AND deleted_at IS NULL";
$sqlAll = "SELECT allergen_name, reaction_severity, last_occurrence, emergency_plan, emergency_plan_details, emergency_protocols, epinephrine_carried 
           FROM allergy_history WHERE patient_id=? $where ORDER BY system_created_at DESC";
$stmA = $connMedicalRegion->prepare($sqlAll);
$stmA->bind_param('i', $patientId);
$stmA->execute();
$ra = $stmA->get_result();
while ($ar = $ra->fetch_assoc()) {
    if (strtolower($ar['epinephrine_carried']) === 'yes') {
        $epinephrineGlobal = 'Yes';
    }
    $allergies[] = $ar;
}
$stmA->close();

$responseData = ['epinephrine_carried' => $epinephrineGlobal, 'allergies' => $allergies];
(new Response)->json($responseData, !empty($allergies) ? 200 : 404);
?>