<?php
// File name: subscriptions.php
// File location: /home/apimedi1/public_html/api/v1/routes/billing/subscriptions.php

// Ensure middleware and utils are available (loaded via init.php)
// If not, add here as fallback (but prefer global in init.php)
// require_once __DIR__ . '/../../middleware/jwt.php';
// require_once __DIR__ . '/../../utils/jwt.php';
// require_once __DIR__ . '/../../handlers/Response.php';

// Rest of the file remains unchanged
requireJWT();
$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();
$user_id = $GLOBALS['auth_user_id'];

switch ($method) {
    case 'GET':
        // List user subscriptions
        $conn_billing = getConnBilling();
        $stmt = $conn_billing->prepare("SELECT * FROM user_subscriptions WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $subscriptions = [];
        while ($row = $result->fetch_assoc()) {
            $subscriptions[] = $row;
        }
        $response->json($subscriptions);
        break;

    case 'POST':
        // Create subscription
        $input = getJsonInput();
        $subscription_id = $input['subscription_id'] ?? null;
        $billing_cycle = $input['billing_cycle'] ?? 'monthly';
        $payment_method = $input['payment_method'] ?? null;

        if (!$subscription_id || !$payment_method) {
            $response->json(['error' => 'Missing required fields'], 400);
        }

        $conn_billing = getConnBilling();
        $stmt = $conn_billing->prepare("INSERT INTO user_subscriptions (user_id, subscription_id, start_date, billing_cycle, next_billing_date, status, payment_method) VALUES (?, ?, CURDATE(), ?, DATE_ADD(CURDATE(), INTERVAL 1 MONTH), 'active', ?)");
        $stmt->bind_param("iiss", $user_id, $subscription_id, $billing_cycle, $payment_method);
        if ($stmt->execute()) {
            $response->json(['success' => true, 'id' => $stmt->insert_id]);
        } else {
            $response->json(['error' => 'Failed to create subscription'], 500);
        }
        break;

    case 'PUT':
        // Update subscription (e.g., change billing cycle)
        if (preg_match('#^billing/subscriptions/(\d+)$#', $uri, $m)) {
            $sub_id = (int)$m[1];
            $input = getJsonInput();
            $new_cycle = $input['billing_cycle'] ?? null;

            if (!$new_cycle) {
                $response->json(['error' => 'Missing billing_cycle'], 400);
            }

            $conn_billing = getConnBilling();
            $stmt = $conn_billing->prepare("UPDATE user_subscriptions SET billing_cycle = ? WHERE id = ? AND user_id = ?");
            $stmt->bind_param("sii", $new_cycle, $sub_id, $user_id);
            if ($stmt->execute()) {
                $response->json(['success' => true]);
            } else {
                $response->json(['error' => 'Failed to update subscription'], 500);
            }
        } else {
            $response->json(['error' => 'Invalid route'], 404);
        }
        break;

    case 'DELETE':
        // Cancel subscription
        if (preg_match('#^billing/subscriptions/(\d+)$#', $uri, $m)) {
            $sub_id = (int)$m[1];
            $conn_billing = getConnBilling();
            $stmt = $conn_billing->prepare("UPDATE user_subscriptions SET status = 'canceled' WHERE id = ? AND user_id = ?");
            $stmt->bind_param("ii", $sub_id, $user_id);
            if ($stmt->execute()) {
                $response->json(['success' => true]);
            } else {
                $response->json(['error' => 'Failed to cancel subscription'], 500);
            }
        } else {
            $response->json(['error' => 'Invalid route'], 404);
        }
        break;

    default:
        $response->json(['error' => 'Method not allowed'], 405);
}