<?php
// File name: logout.php
// File location: /home/apimedi1/public_html/api/v1/routes/auth/logout.php

require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';
require_once __DIR__ . '/../../../../../secure/config_v2.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

$response = new Response();
$input = getJsonInput();

// Extract token from Authorization header
$header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
if (!preg_match('/Bearer\s+(\S+)/', $header, $matches)) {
    $response->json(['error' => 'Missing token'], 401);
}
$token = $matches[1];

$connAPI = getConnAPI();
if (!$connAPI) {
    $response->json(['error' => 'Database connection failed'], 500);
}

// 1. Check if it's a long-lived device token
$stmtDevice = $connAPI->prepare("
    SELECT token FROM user_device_tokens 
    WHERE token = ? AND is_revoked = 0 AND (deleted_at IS NULL)
");
$stmtDevice->bind_param('s', $token);
$stmtDevice->execute();
$resultDevice = $stmtDevice->get_result();

if ($resultDevice->num_rows > 0) {
    // This is a device token → revoke it on backend
    $stmtRevoke = $connAPI->prepare("
        UPDATE user_device_tokens 
        SET is_revoked = 1, revoked_at = NOW() 
        WHERE token = ?
    ");
    $stmtRevoke->bind_param('s', $token);
    if ($stmtRevoke->execute()) {
        $response->json(['success' => true, 'message' => 'Logged out successfully. Device token revoked.'], 200);
    } else {
        $response->json(['error' => 'Failed to revoke device token'], 500);
    }
    $stmtRevoke->close();
} else {
    // Not a device token → assume short-lived JWT (no revocation needed, just clear on client)
    $response->json(['success' => true, 'message' => 'Logged out successfully. JWT cleared on client.'], 200);
}

$stmtDevice->close();
?>