<?php
// File name: device-refresh.php
// File location: /home/apimedi1/public_html/api/v1/routes/auth/device-refresh.php
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';
require_once __DIR__ . '/../../../../../secure/config_v2.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    (new Response)->json(['error' => 'Method Not Allowed'], 405);
}

// Validate device token (via middleware)
$header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
if (!preg_match('/Bearer\s+(\S+)/', $header, $matches)) {
    (new Response)->json(['error' => 'Missing token'], 401);
}
$payload = validateDeviceOrNormalToken($matches[1]);
if (!$payload || !$payload['deviceToken']) {  // Ensure it's specifically a device token
    (new Response)->json(['error' => 'Invalid or non-device token'], 401);
}

$userId = $payload['userId'];
$regionCode = $payload['regionCode'] ?? 'NA';

// Generate fresh short-lived JWT
$newJwt = generateJWT($userId, $regionCode);

// Optional: Log the refresh (similar to login log if needed)

(new Response)->json([
    'token' => $newJwt,
    'message' => 'Device refresh successful',
    'regionCode' => $regionCode
], 200);
?>