<?php
// File name: referral-link.php
// File location: /home/apimedi1/public_html/api/v1/routes/affiliate/referral-link.php
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../handlers/Response.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';
$user_id = requireJWT();
$user_id_str = (string)$user_id;
$conn = getDatabaseConnection('affiliates', 'GBL');
if (!$conn) {
    logError('Database connection failed for affiliate referral link', 'Database', __FILE__, __LINE__);
    (new Response)->json(['error' => 'Database connection failed'], 500);
}
$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();
if ($method !== 'GET') {
    $response->json(['error' => 'Method not allowed'], 405);
}
if (!isset($_GET['affiliate_id'])) {
    $response->json(['error' => 'Missing affiliate_id'], 400);
}
$aff_code = $_GET['affiliate_id'];
// Verify ownership
$stmt = $conn->prepare("SELECT affiliate_id FROM affiliates WHERE affiliate_id = ? AND user_id = ? AND deleted_at IS NULL");
$stmt->bind_param("ss", $aff_code, $user_id_str);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();
if (!$row) {
    $response->json(['error' => 'Affiliate not found or unauthorized'], 403);
}
$affiliate_id = $row['affiliate_id'];
$stmt->close();
// Generate referral link with environment-aware main site URL
$main_site_url = (ENVIRONMENT === 'development') ? 'https://www.meditag.net' : 'https://www.meditag.com';
$referral_link = $main_site_url . '/aff-landing.php?ref=' . urlencode($affiliate_id);
$response->json(['referral_link' => $referral_link]);
?>