<?php
// File name: logApiResponse.php
// File location: /home/apimedi1/public_html/api/v1/handlers/logApiResponse.php

function logApiResponse($request_id, $status_code, $response_body, $error_message, $ip_address, $user_id) {
    $conn = getConnAPI();
    if (!$conn) return;

    $summary = substr($response_body, 0, 255);
    $stmt = $conn->prepare("INSERT INTO api_responses (request_id, status_code, response_body_summary, error_message, ip_address, user_id, created_at) VALUES (?, ?, ?, ?, ?, ?, NOW())");
    if (!$stmt) return;

    // Handle null user_id properly for bind_param (fixes "parameter by reference" error)
    $user_id_param = $user_id ? (int)$user_id : null;
    $types = "sisss";
    $params = [$request_id, $status_code, $summary, $error_message, $ip_address];
    if ($user_id_param !== null) {
        $types .= "i";
        $params[] = $user_id_param;
    }
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $stmt->close();
}
?>