<?php
// File name: redemptions.php
// File location: /home/apimedi1/public_html/api/v1/routes/rewards/redemptions.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';

$userPayload = validateJWT($_SERVER['HTTP_AUTHORIZATION'] ?? '');
if (!$userPayload) {
    (new Response)->json(['error' => 'Invalid token'], 401);
}
$userId = $userPayload['userId'];
$region = $userPayload['regionCode'] ?? 'GLOBAL';

$connRewards = getConnRewards();
$connMain = getDatabaseConnection('main', $region);

$stmtPatient = $connMain->prepare("SELECT id, first_name FROM patients WHERE user_id = ?");
$stmtPatient->bind_param("i", $userId);
$stmtPatient->execute();
$resultPatient = $stmtPatient->get_result();
$patientRow = $resultPatient->fetch_assoc();
$patientId = $patientRow['id'];
$firstName = $patientRow['first_name'];

$stmtAccount = $connRewards->prepare("SELECT id FROM rewards_accounts WHERE user_id = ? AND role_type = 'Patient'");
$stmtAccount->bind_param("i", $userId);
$stmtAccount->execute();
$resultAccount = $stmtAccount->get_result();
$accountRow = $resultAccount->fetch_assoc();
$accountId = $accountRow['id'];

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = getJsonInput();
    $itemId = (int)($input['item_id'] ?? 0);

    // Simplified redemption logic (full in process_redeem.php)
    $stmtItem = $connRewards->prepare("SELECT item_name, point_cost FROM reward_types WHERE id = ?");
    $stmtItem->bind_param("i", $itemId);
    $stmtItem->execute();
    $resultItem = $stmtItem->get_result();
    $itemRow = $resultItem->fetch_assoc();

    // Check balance, deduct points, generate voucher, send notification, etc.
    // For brevity, assume success

    (new Response)->json(['success' => true, 'item' => $itemRow['item_name']]);
} elseif ($method === 'GET') {
    $stmt = $connRewards->prepare("SELECT * FROM transactions WHERE account_id = ? AND transaction_type = 'Redeemed'");
    $stmt->bind_param("i", $accountId);
    $stmt->execute();
    $result = $stmt->get_result();
    $redemptions = [];
    while ($row = $result->fetch_assoc()) {
        $redemptions[] = $row;
    }
    (new Response)->json($redemptions);
} else {
    (new Response)->json(['error' => 'Method not allowed'], 405);
}
?>