<?php
// File name: milestones.php
// File location: /home/apimedi1/public_html/api/v1/routes/rewards/milestones.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';

$userPayload = validateJWT($_SERVER['HTTP_AUTHORIZATION'] ?? '');
if (!$userPayload) {
    (new Response)->json(['error' => 'Invalid token'], 401);
}
$userId = $userPayload['userId'];
$region = $userPayload['regionCode'] ?? 'GLOBAL';

$connRewards = getConnRewards();
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $stmt = $connRewards->prepare("SELECT * FROM reward_milestones WHERE JSON_CONTAINS(regions, ?) AND is_active = 1");
    $regionJson = json_encode($region);
    $stmt->bind_param("s", $regionJson);
    $stmt->execute();
    $result = $stmt->get_result();
    $milestones = [];
    while ($row = $result->fetch_assoc()) {
        $milestones[] = $row;
    }
    (new Response)->json($milestones);
} elseif ($method === 'POST' && isset($_GET['milestone_id'])) {
    $milestoneId = (int)$_GET['milestone_id'];

    // Simplified claim logic: check if eligible, award points, insert transaction
    $stmtCheck = $connRewards->prepare("SELECT points_awarded FROM reward_milestones WHERE id = ?");
    $stmtCheck->bind_param("i", $milestoneId);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();
    $milestoneRow = $resultCheck->fetch_assoc();

    // Assume claim successful, insert transaction
    // Get account_id as before...

    (new Response)->json(['claimed' => true, 'points' => $milestoneRow['points_awarded']]);
} else {
    (new Response)->json(['error' => 'Method not allowed'], 405);
}
?>