<?php
// File name: updates.php
// File location: /home/apimedi1/public_html/api/v1/routes/panic/updates.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../../../../secure/config_v2.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

$response = new Response();
$input = getJsonInput();
$method = $_SERVER['REQUEST_METHOD'];

$conn_panic = getDatabaseConnection('panic_service', 'GBL');
if (!$conn_panic) {
    $response->json(['error' => 'Database connection failed'], 500);
}

if ($method !== 'POST') {
    $response->json(['error' => 'Method not allowed'], 405);
}

requireJWT(); // Admin check can be added

$event_id = (int)$_GET['id'] ?? 0;
if (!$event_id) {
    $response->json(['error' => 'Missing event_id'], 400);
}

$update_message = $input['update_message'] ?? '';
$updated_by = (int)$input['updated_by'] ?? $GLOBALS['auth_user_id']; // From JWT
$key = bin2hex(random_bytes(32)); // Generate new key

if (empty($update_message)) {
    $response->json(['error' => 'Missing update_message'], 400);
}

$stmt = $conn_panic->prepare("
    INSERT INTO event_updates (event_id, update_message, updated_by, `key`, created_at)
    VALUES (?, ?, ?, ?, NOW())
");
$stmt->bind_param('isis', $event_id, $update_message, $updated_by, $key);
if ($stmt->execute()) {
    $response->json(['success' => true, 'message' => 'Update added', 'key' => $key], 201);
} else {
    $response->json(['success' => false, 'message' => $stmt->error], 500);
}
$stmt->close();